/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.geometry.jts.JTS;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JoinId;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.Identifier;

public class PreparedFilterToSQL
extends FilterToSQL {
    protected List<Object> literalValues = new ArrayList<Object>();
    protected List<Class> literalTypes = new ArrayList<Class>();
    protected List<Integer> SRIDs = new ArrayList<Integer>();
    protected List<Integer> dimensions = new ArrayList<Integer>();
    protected List<AttributeDescriptor> descriptors = new ArrayList<AttributeDescriptor>();
    protected PreparedStatementSQLDialect dialect;
    boolean prepareEnabled = true;

    public PreparedFilterToSQL(PreparedStatementSQLDialect dialect) {
        this.dialect = dialect;
    }

    public boolean isPrepareEnabled() {
        return this.prepareEnabled;
    }

    public void setPrepareEnabled(boolean prepareEnabled) {
        this.prepareEnabled = prepareEnabled;
    }

    public PreparedFilterToSQL(Writer out) {
        super(out);
    }

    @Override
    public Object visit(Literal expression, Object context) throws RuntimeException {
        if (!this.prepareEnabled) {
            return super.visit(expression, context);
        }
        Class clazz = this.getTargetClassFromContext(context);
        Object literalValue = this.evaluateLiteral(expression, clazz);
        if (literalValue instanceof Envelope && this.convertEnvelopeToPolygon()) {
            clazz = Polygon.class;
            literalValue = JTS.toGeometry((Envelope)literalValue);
        }
        if (clazz == null && literalValue != null) {
            clazz = literalValue.getClass();
        }
        this.literalValues.add(literalValue);
        this.SRIDs.add(this.currentSRID);
        this.dimensions.add(this.currentDimension);
        this.descriptors.add(context instanceof AttributeDescriptor ? (AttributeDescriptor)context : null);
        this.literalTypes.add(clazz);
        try {
            if (literalValue == null || this.dialect == null) {
                this.out.write("?");
            } else {
                StringBuffer sb = new StringBuffer();
                if (Geometry.class.isAssignableFrom(literalValue.getClass())) {
                    int srid = this.currentSRID != null ? this.currentSRID : -1;
                    int dimension = this.currentDimension != null ? this.currentDimension : -1;
                    this.dialect.prepareGeometryValue((Geometry)literalValue, dimension, srid, Geometry.class, sb);
                } else if (this.encodingFunction) {
                    this.dialect.prepareFunctionArgument(clazz, sb);
                } else {
                    sb.append("?");
                }
                this.out.write(sb.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return context;
    }

    protected boolean convertEnvelopeToPolygon() {
        return true;
    }

    private Class getTargetClassFromContext(Object context) {
        if (context instanceof Class) {
            return (Class)context;
        }
        if (context instanceof AttributeDescriptor) {
            return ((AttributeDescriptor)context).getType().getBinding();
        }
        return null;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        if (this.primaryKey == null) {
            throw new RuntimeException("Must set a primary key before trying to encode FIDFilters");
        }
        Set<Identifier> ids = filter.getIdentifiers();
        List<PrimaryKeyColumn> columns = this.primaryKey.getColumns();
        Iterator<Identifier> i = ids.iterator();
        while (i.hasNext()) {
            try {
                Identifier id = i.next();
                List<Object> attValues = JDBCDataStore.decodeFID(this.primaryKey, id.toString(), false);
                this.out.write("(");
                for (int j = 0; j < attValues.size(); ++j) {
                    if (filter instanceof JoinId) {
                        this.out.write(this.escapeName(((JoinId)filter).getAlias()));
                        this.out.write(".");
                    }
                    this.out.write(this.escapeName(columns.get(j).getName()));
                    this.out.write(" = ");
                    this.out.write(63);
                    this.literalValues.add(attValues.get(j));
                    this.SRIDs.add(-1);
                    this.dimensions.add(-1);
                    this.literalTypes.add(attValues.get(j) != null ? attValues.get(j).getClass() : null);
                    this.descriptors.add(null);
                    if (j >= attValues.size() - 1) continue;
                    this.out.write(" AND ");
                }
                this.out.write(")");
                if (!i.hasNext()) continue;
                this.out.write(" OR ");
            }
            catch (IOException e) {
                throw new RuntimeException("io problem writing filter", e);
            }
        }
        return extraData;
    }

    public List<Object> getLiteralValues() {
        return this.literalValues;
    }

    public List<Class> getLiteralTypes() {
        return this.literalTypes;
    }

    public List<Integer> getSRIDs() {
        return this.SRIDs;
    }

    public List<Integer> getDimensions() {
        return this.dimensions;
    }

    public List<AttributeDescriptor> getDescriptors() {
        return this.descriptors;
    }
}

