/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg.geom;

import java.io.IOException;
import java.io.InputStream;
import org.geotools.geometry.jts.JTS;
import org.geotools.geopkg.geom.EnvelopeType;
import org.geotools.geopkg.geom.GeometryHeader;
import org.geotools.geopkg.geom.GeometryHeaderFlags;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ByteArrayInStream;
import org.locationtech.jts.io.ByteOrderDataInStream;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;

public class GeoPkgGeomReader {
    static final GeometryFactory DEFAULT_GEOM_FACTORY = new GeometryFactory();
    protected InStream input;
    protected GeometryHeader header = null;
    protected Geometry geometry = null;
    private GeometryFactory factory = DEFAULT_GEOM_FACTORY;
    private Number simplificationDistance;
    private Class geometryType;

    public GeoPkgGeomReader(InStream input) {
        this.input = input;
    }

    public GeoPkgGeomReader(InputStream input) throws IOException {
        this.input = new InputStreamInStream(input);
    }

    public GeoPkgGeomReader(byte[] bytes) {
        this.input = new ByteArrayInStream(bytes);
    }

    public GeometryHeader getHeader() throws IOException {
        if (this.header == null) {
            try {
                this.header = this.readHeader();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        return this.header;
    }

    public Geometry get() throws IOException {
        if (this.header == null) {
            try {
                this.header = this.readHeader();
            }
            catch (ParseException e) {
                throw new IOException(e);
            }
        }
        if (this.geometry == null) {
            Geometry simplified;
            Envelope envelope = this.header.getEnvelope();
            if (this.simplificationDistance != null && this.geometryType != null && this.header.getFlags().getEnvelopeIndicator() != EnvelopeType.NONE && envelope.getWidth() < this.simplificationDistance.doubleValue() && envelope.getHeight() < this.simplificationDistance.doubleValue() && (simplified = this.getSimplifiedShape(this.geometryType, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY())) != null) {
                this.geometry = simplified;
            }
            if (this.geometry == null) {
                this.geometry = this.read();
            }
        }
        return this.geometry;
    }

    public Geometry getSimplifiedShape(Class type, double minX, double minY, double maxX, double maxY) {
        CoordinateSequenceFactory csf = this.factory.getCoordinateSequenceFactory();
        if (Point.class.equals((Object)type)) {
            CoordinateSequence cs = JTS.createCS(csf, 1, 2);
            cs.setOrdinate(0, 0, (minX + maxX) / 2.0);
            cs.setOrdinate(0, 1, (minY + maxY) / 2.0);
            return this.factory.createPoint(cs);
        }
        if (MultiPoint.class.equals((Object)type)) {
            Point p = (Point)this.getSimplifiedShape(Point.class, minX, minY, maxX, maxY);
            return this.factory.createMultiPoint(new Point[]{p});
        }
        if (LineString.class.equals((Object)type) || LinearRing.class.equals((Object)type)) {
            CoordinateSequence cs = JTS.createCS(csf, 2, 2);
            cs.setOrdinate(0, 0, minX);
            cs.setOrdinate(0, 1, minY);
            cs.setOrdinate(1, 0, maxX);
            cs.setOrdinate(1, 1, maxY);
            return this.factory.createLineString(cs);
        }
        if (MultiLineString.class.equals((Object)type)) {
            LineString ls = (LineString)this.getSimplifiedShape(LineString.class, minX, minY, maxX, maxY);
            return this.factory.createMultiLineString(new LineString[]{ls});
        }
        if (Polygon.class.equals((Object)type)) {
            CoordinateSequence cs = JTS.createCS(csf, 5, 2);
            cs.setOrdinate(0, 0, minX);
            cs.setOrdinate(0, 1, minY);
            cs.setOrdinate(1, 0, minX);
            cs.setOrdinate(1, 1, maxY);
            cs.setOrdinate(2, 0, maxX);
            cs.setOrdinate(2, 1, maxY);
            cs.setOrdinate(3, 0, maxX);
            cs.setOrdinate(3, 1, minY);
            cs.setOrdinate(4, 0, minX);
            cs.setOrdinate(4, 1, minY);
            LinearRing ring = this.factory.createLinearRing(cs);
            return this.factory.createPolygon(ring, null);
        }
        if (MultiPolygon.class.equals((Object)type) || GeometryCollection.class.equals((Object)type)) {
            Polygon polygon = (Polygon)this.getSimplifiedShape(Polygon.class, minX, minY, maxX, maxY);
            return this.factory.createMultiPolygon(new Polygon[]{polygon});
        }
        return null;
    }

    public Envelope getEnvelope() throws IOException {
        if (this.getHeader().getFlags().getEnvelopeIndicator() == EnvelopeType.NONE) {
            return this.get().getEnvelopeInternal();
        }
        return this.getHeader().getEnvelope();
    }

    protected Geometry read() throws IOException {
        try {
            WKBReader wkbReader = new WKBReader(this.factory);
            Geometry g = wkbReader.read(this.input);
            g.setSRID(this.header.getSrid());
            return g;
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    protected GeometryHeader readHeader() throws IOException, ParseException {
        GeometryHeader h = new GeometryHeader();
        byte[] buf = new byte[4];
        this.input.read(buf);
        h.setFlags(new GeometryHeaderFlags(buf[3]));
        ByteOrderDataInStream din = new ByteOrderDataInStream(this.input);
        din.setOrder(h.getFlags().getEndianess());
        h.setSrid(din.readInt());
        if (h.getFlags().getEnvelopeIndicator() != EnvelopeType.NONE) {
            double x1 = din.readDouble();
            double x2 = din.readDouble();
            double y1 = din.readDouble();
            double y2 = din.readDouble();
            if (h.getFlags().getEnvelopeIndicator().getValue() > 1) {
                din.readDouble();
                din.readDouble();
            }
            if (h.getFlags().getEnvelopeIndicator().getValue() > 3) {
                din.readDouble();
                din.readDouble();
            }
            h.setEnvelope(new Envelope(x1, x2, y1, y2));
        }
        return h;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public void setFactory(GeometryFactory factory) {
        if (factory != null) {
            this.factory = factory;
        }
    }

    public void setHints(Hints hints) {
        if (hints != null) {
            this.simplificationDistance = (Number)hints.get(Hints.GEOMETRY_DISTANCE);
        }
    }

    public void setGeometryType(Class geometryType) {
        this.geometryType = geometryType;
    }
}

