/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.CurvedGeometryFactory;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Assert;

public class WKTReader2
extends WKTReader {
    private static final String EMPTY = "EMPTY";
    private static final String COMMA = ",";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String NAN_SYMBOL = "NaN";
    private CurvedGeometryFactory geometryFactory;
    private PrecisionModel precisionModel;
    private StreamTokenizer tokenizer;

    public WKTReader2() {
        this(JTSFactoryFinder.getGeometryFactory(null));
    }

    public WKTReader2(double tolerance) {
        this(new CurvedGeometryFactory(JTSFactoryFinder.getGeometryFactory(null), tolerance));
    }

    public WKTReader2(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory instanceof CurvedGeometryFactory ? (CurvedGeometryFactory)geometryFactory : new CurvedGeometryFactory(geometryFactory, Double.MAX_VALUE);
        this.precisionModel = geometryFactory.getPrecisionModel();
    }

    public Geometry read(String wellKnownText) throws ParseException {
        try (StringReader reader = new StringReader(wellKnownText);){
            Geometry geometry = this.read(reader);
            return geometry;
        }
    }

    public Geometry read(Reader reader) throws ParseException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.wordChars(160, 255);
        this.tokenizer.wordChars(48, 57);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.wordChars(43, 43);
        this.tokenizer.wordChars(46, 46);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.commentChar(35);
        try {
            return this.readGeometryTaggedText();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private Coordinate[] getCoordinates() throws IOException, ParseException {
        return this.getCoordinates(false);
    }

    private Coordinate[] getCoordinates(boolean measures) throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new Coordinate[0];
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate(measures));
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate(measures));
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private List<Coordinate> getCoordinateList(boolean openExpected) throws IOException, ParseException {
        String nextToken;
        if (openExpected && (nextToken = this.getNextEmptyOrOpener()).equals(EMPTY)) {
            return Collections.emptyList();
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        return coordinates;
    }

    private Coordinate getPreciseCoordinate() throws IOException, ParseException {
        return this.getPreciseCoordinate(false);
    }

    private Coordinate getPreciseCoordinate(boolean measures) throws IOException, ParseException {
        CoordinateXYZM coord;
        Object object = coord = measures ? new CoordinateXYZM() : new Coordinate();
        if (this.isEmptyNext()) {
            this.tokenizer.nextToken();
            return null;
        }
        int i = 0;
        while (this.isNumberNext()) {
            coord.setOrdinate(i, this.getNextNumber());
            ++i;
        }
        this.precisionModel.makePrecise((Coordinate)coord);
        return coord;
    }

    private boolean isEmptyNext() throws IOException {
        this.tokenizer.nextToken();
        boolean ret = false;
        if (this.tokenizer.sval.equalsIgnoreCase(EMPTY)) {
            ret = true;
        }
        this.tokenizer.pushBack();
        return ret;
    }

    private boolean isNumberNext() throws IOException {
        int type = this.tokenizer.nextToken();
        this.tokenizer.pushBack();
        return type == -3;
    }

    private double getNextNumber() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                if (this.tokenizer.sval.equalsIgnoreCase(NAN_SYMBOL)) {
                    return Double.NaN;
                }
                try {
                    return Double.parseDouble(this.tokenizer.sval);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("Invalid number: " + this.tokenizer.sval);
                }
            }
        }
        this.parseError("number");
        return 0.0;
    }

    private String getNextEmptyOrOpener() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(EMPTY) || nextWord.equals(L_PAREN)) {
            return nextWord;
        }
        this.parseError("EMPTY or (");
        return null;
    }

    private String getNextCloserOrComma() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(COMMA) || nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(", or )");
        return null;
    }

    private String getNextCloser() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(R_PAREN)) {
            return nextWord;
        }
        this.parseError(R_PAREN);
        return null;
    }

    private String getNextWord() throws IOException, ParseException {
        int type = this.tokenizer.nextToken();
        switch (type) {
            case -3: {
                String word = this.tokenizer.sval;
                if (word.equalsIgnoreCase(EMPTY)) {
                    return EMPTY;
                }
                return word;
            }
            case 40: {
                return L_PAREN;
            }
            case 41: {
                return R_PAREN;
            }
            case 44: {
                return COMMA;
            }
        }
        this.parseError("word");
        return null;
    }

    private void parseError(String expected) throws ParseException {
        if (this.tokenizer.ttype == -2) {
            Assert.shouldNeverReachHere((String)"Unexpected NUMBER token");
        }
        if (this.tokenizer.ttype == 10) {
            Assert.shouldNeverReachHere((String)"Unexpected EOL token");
        }
        String tokenStr = this.tokenString();
        throw new ParseException("Expected " + expected + " but found " + tokenStr);
    }

    private String tokenString() {
        switch (this.tokenizer.ttype) {
            case -2: {
                return "<NUMBER>";
            }
            case 10: {
                return "End-of-Line";
            }
            case -1: {
                return "End-of-Stream";
            }
            case -3: {
                return "'" + this.tokenizer.sval + "'";
            }
        }
        return "'" + (char)this.tokenizer.ttype + "'";
    }

    private Geometry readGeometryTaggedText() throws IOException, ParseException {
        String type = null;
        try {
            type = this.getNextWord();
        }
        catch (IOException | ParseException e) {
            return null;
        }
        if (type.equalsIgnoreCase("POINT")) {
            return this.readPointText();
        }
        if (type.equalsIgnoreCase("LINESTRING")) {
            return this.readLineStringText();
        }
        if (type.equalsIgnoreCase("LINEARRING")) {
            return this.readLinearRingText();
        }
        if (type.equalsIgnoreCase("POLYGON")) {
            return this.readPolygonText();
        }
        if (type.equalsIgnoreCase("MULTIPOINT")) {
            return this.readMultiPointText();
        }
        if (type.equalsIgnoreCase("MULTILINESTRING")) {
            return this.readMultiLineStringText();
        }
        if (type.equalsIgnoreCase("MULTICURVE")) {
            return this.readMultiCurveText();
        }
        if (type.equalsIgnoreCase("MULTIPOLYGON")) {
            return this.readMultiPolygonText();
        }
        if (type.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
            return this.readGeometryCollectionText();
        }
        if (type.equalsIgnoreCase("CIRCULARSTRING")) {
            return this.readCircularStringText();
        }
        if (type.equalsIgnoreCase("COMPOUNDCURVE")) {
            return this.readCompoundCurveText();
        }
        if (type.equalsIgnoreCase("CURVEPOLYGON")) {
            return this.readCurvePolygonText();
        }
        if (type.equalsIgnoreCase("MULTISURFACE")) {
            return this.readMultiSurfaceText();
        }
        if (type.equalsIgnoreCase("LINESTRINGZ")) {
            return this.readLineStringText(3, 0);
        }
        if (type.equalsIgnoreCase("LINESTRINGM")) {
            return this.readLineStringText(3, 1);
        }
        if (type.equalsIgnoreCase("LINESTRINGZM")) {
            return this.readLineStringText(4, 1);
        }
        throw new ParseException("Unknown geometry type: " + type);
    }

    private Point readPointText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPoint((Coordinate)null);
        }
        Point point = this.geometryFactory.createPoint(this.getPreciseCoordinate());
        this.getNextCloser();
        return point;
    }

    private LineString readLineStringText() throws IOException, ParseException {
        return this.readLineStringText(2, 0);
    }

    private LineString readLineStringText(int dimension, int measures) throws IOException, ParseException {
        if (measures == 0) {
            return this.geometryFactory.createLineString(this.getCoordinates());
        }
        return this.geometryFactory.createLineString(this.buildCoordinateSequence(this.getCoordinates(true), dimension, measures));
    }

    private CoordinateSequence buildCoordinateSequence(Coordinate[] coordinates, int dimension, int measures) {
        LiteCoordinateSequence coordinateSequence = new LiteCoordinateSequence(coordinates.length, dimension, measures);
        this.insertCoordinates(coordinates, (CoordinateSequence)coordinateSequence);
        return coordinateSequence;
    }

    private void insertCoordinates(Coordinate[] coordinates, CoordinateSequence coordinateSequence) {
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate coordinate = coordinates[i];
            for (int j = 0; j < coordinateSequence.getDimension(); ++j) {
                coordinateSequence.setOrdinate(i, j, coordinate.getOrdinate(j));
            }
        }
    }

    private LineString readCircularStringText() throws IOException, ParseException {
        List<Coordinate> coordinates = this.getCoordinateList(true);
        if (coordinates.isEmpty()) {
            return this.geometryFactory.createCurvedGeometry((CoordinateSequence)new LiteCoordinateSequence(new Coordinate[0]));
        }
        if (coordinates.size() < 3) {
            throw new ParseException("A CIRCULARSTRING must contain at least 3 control points");
        }
        double[] controlPoints = this.toControlPoints(coordinates);
        return this.geometryFactory.createCurvedGeometry(2, controlPoints);
    }

    private double[] toControlPoints(List<Coordinate> coordinates) {
        double[] result = new double[coordinates.size() * 2];
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate c = coordinates.get(i);
            result[i * 2] = c.x;
            result[i * 2 + 1] = c.y;
        }
        return result;
    }

    private LineString readCompoundCurveText() throws IOException, ParseException {
        List<LineString> lineStrings = this.getLineStrings();
        return this.geometryFactory.createCurvedGeometry(lineStrings);
    }

    List<LineString> getLineStrings() throws IOException, ParseException {
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        String nextWord = this.getNextEmptyOrOpener();
        if (nextWord.equals(EMPTY)) {
            return lineStrings;
        }
        nextWord = COMMA;
        while (nextWord.equals(COMMA)) {
            nextWord = this.getNextWord();
            if (nextWord.equals(L_PAREN)) {
                List<Coordinate> coords = this.getCoordinateList(false);
                LineString lineString = this.geometryFactory.createLineString(coords.toArray(new Coordinate[coords.size()]));
                lineStrings.add(lineString);
            } else if (nextWord.equalsIgnoreCase("CIRCULARSTRING")) {
                LineString circularString = this.readCircularStringText();
                lineStrings.add(circularString);
            } else if (nextWord.equalsIgnoreCase("COMPOUNDCURVE")) {
                LineString compound = this.readCompoundCurveText();
                lineStrings.add(compound);
            }
            nextWord = this.getNextCloserOrComma();
        }
        return lineStrings;
    }

    private LinearRing readCurvedLinearRingText() throws IOException, ParseException {
        String nextWord = this.getNextWord();
        if (nextWord.equals(L_PAREN)) {
            List<Coordinate> coords = this.getCoordinateList(false);
            return new LinearRing((CoordinateSequence)new CoordinateArraySequence(coords.toArray(new Coordinate[coords.size()])), (GeometryFactory)this.geometryFactory);
        }
        if (nextWord.equalsIgnoreCase("CIRCULARSTRING")) {
            return (LinearRing)this.readCircularStringText();
        }
        if (nextWord.equalsIgnoreCase("COMPOUNDCURVE")) {
            return (LinearRing)this.readCompoundCurveText();
        }
        this.parseError("(, CIRCULARSTRING or COMPOUNDCURVE");
        return null;
    }

    private LinearRing readLinearRingText() throws IOException, ParseException {
        return this.geometryFactory.createLinearRing(this.getCoordinates());
    }

    private MultiPoint readMultiPointText() throws IOException, ParseException {
        return this.geometryFactory.createMultiPoint(this.toPoints(this.getCoordinatesForMultiPoint()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Coordinate[] getCoordinatesForMultiPoint() throws IOException, ParseException {
        ArrayList<Coordinate> coordinates;
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return new Coordinate[0];
        }
        boolean innerParens = false;
        try {
            String peek = this.getNextWord();
            innerParens = peek.equals(L_PAREN);
        }
        catch (ParseException peek) {
        }
        finally {
            this.tokenizer.pushBack();
        }
        if (innerParens) {
            coordinates = new ArrayList<Coordinate>();
            Coordinate[] coords = this.getCoordinates();
            coordinates.add(coords[0]);
            nextToken = this.getNextCloserOrComma();
            while (nextToken.equals(COMMA)) {
                coords = this.getCoordinates();
                coordinates.add(coords[0]);
                nextToken = this.getNextCloserOrComma();
            }
            Coordinate[] array = new Coordinate[coordinates.size()];
            return coordinates.toArray(array);
        }
        coordinates = new ArrayList();
        coordinates.add(this.getPreciseCoordinate());
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            coordinates.add(this.getPreciseCoordinate());
            nextToken = this.getNextCloserOrComma();
        }
        Coordinate[] array = new Coordinate[coordinates.size()];
        return coordinates.toArray(array);
    }

    private Point[] toPoints(Coordinate ... coordinates) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Coordinate coordinate : coordinates) {
            if (coordinate == null) {
                points.add((Point)this.geometryFactory.createEmpty(0));
                continue;
            }
            points.add(this.geometryFactory.createPoint(coordinate));
        }
        return points.toArray(new Point[points.size()]);
    }

    private Polygon readPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createPolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        LinearRing shell = this.readLinearRingText();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createPolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiCurveText() throws IOException, ParseException {
        List<LineString> lineStrings = this.getLineStrings();
        return this.geometryFactory.createMultiCurve(lineStrings);
    }

    private Polygon readCurvePolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createCurvePolygon(this.geometryFactory.createLinearRing(new Coordinate[0]), new LinearRing[0]);
        }
        if (!nextToken.equals(L_PAREN)) {
            this.parseError("Ring expected");
        }
        LinearRing shell = this.readCurvedLinearRingText();
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            LinearRing hole = this.readCurvedLinearRingText();
            holes.add(hole);
            nextToken = this.getNextCloserOrComma();
        }
        LinearRing[] array = new LinearRing[holes.size()];
        return this.geometryFactory.createCurvePolygon(shell, holes.toArray(array));
    }

    private MultiLineString readMultiLineStringText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiLineString(new LineString[0]);
        }
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        LineString lineString = this.readLineStringText();
        lineStrings.add(lineString);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            lineString = this.readLineStringText();
            lineStrings.add(lineString);
            nextToken = this.getNextCloserOrComma();
        }
        LineString[] array = new LineString[lineStrings.size()];
        return this.geometryFactory.createMultiLineString(lineStrings.toArray(array));
    }

    private MultiPolygon readMultiPolygonText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiPolygon(new Polygon[0]);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        Polygon polygon = this.readPolygonText();
        polygons.add(polygon);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            polygon = this.readPolygonText();
            polygons.add(polygon);
            nextToken = this.getNextCloserOrComma();
        }
        Polygon[] array = new Polygon[polygons.size()];
        return this.geometryFactory.createMultiPolygon(polygons.toArray(array));
    }

    private MultiPolygon readMultiSurfaceText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createMultiSurface(new ArrayList<Polygon>());
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        String nextWord = COMMA;
        while (nextWord.equals(COMMA)) {
            Polygon polygon;
            nextWord = this.getNextWord();
            if (nextWord.equals(L_PAREN) || nextWord.equals(EMPTY)) {
                this.tokenizer.pushBack();
                polygon = this.readPolygonText();
                polygons.add(polygon);
            } else if (nextWord.equalsIgnoreCase("CURVEPOLYGON")) {
                polygon = this.readCurvePolygonText();
                polygons.add(polygon);
            }
            nextWord = this.getNextCloserOrComma();
        }
        return this.geometryFactory.createMultiSurface(polygons);
    }

    private GeometryCollection readGeometryCollectionText() throws IOException, ParseException {
        String nextToken = this.getNextEmptyOrOpener();
        if (nextToken.equals(EMPTY)) {
            return this.geometryFactory.createGeometryCollection(new Geometry[0]);
        }
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        Geometry geometry = this.readGeometryTaggedText();
        geometries.add(geometry);
        nextToken = this.getNextCloserOrComma();
        while (nextToken.equals(COMMA)) {
            geometry = this.readGeometryTaggedText();
            geometries.add(geometry);
            nextToken = this.getNextCloserOrComma();
        }
        Geometry[] array = new Geometry[geometries.size()];
        return this.geometryFactory.createGeometryCollection(geometries.toArray(array));
    }
}

