/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.ClippedFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class ClippedFeatureCollection
extends DecoratingSimpleFeatureCollection {
    protected Geometry clip;
    protected SimpleFeatureType targetSchema;
    protected boolean preserveZ;
    static final Logger LOGGER = Logging.getLogger(ClippedFeatureCollection.class);

    public ClippedFeatureCollection(SimpleFeatureCollection delegate, Geometry clip, boolean preserveZ) {
        super(delegate);
        this.clip = clip;
        this.targetSchema = this.buildTargetSchema((SimpleFeatureType)delegate.getSchema());
        this.preserveZ = preserveZ;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.targetSchema;
    }

    private SimpleFeatureType buildTargetSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (ad instanceof GeometryDescriptor) {
                GeometryDescriptor gd = (GeometryDescriptor)ad;
                Class<?> binding = ad.getType().getBinding();
                if (Point.class.isAssignableFrom(binding) || GeometryCollection.class.isAssignableFrom(binding)) {
                    tb.add(ad);
                    continue;
                }
                Class target = LineString.class.isAssignableFrom(binding) ? MultiLineString.class : (Polygon.class.isAssignableFrom(binding) ? MultiPolygon.class : Geometry.class);
                tb.minOccurs(ad.getMinOccurs());
                tb.maxOccurs(ad.getMaxOccurs());
                tb.nillable(ad.isNillable());
                tb.add(ad.getLocalName(), target, gd.getCoordinateReferenceSystem());
                continue;
            }
            tb.add(ad);
        }
        tb.setName(schema.getName());
        return tb.buildFeatureType();
    }

    @Override
    public SimpleFeatureIterator features() {
        return new ClippedFeatureIterator(this.delegate.features(), this.clip, this.getSchema(), this.preserveZ);
    }

    @Override
    public int size() {
        try (SimpleFeatureIterator fi = this.features();){
            int count = 0;
            while (fi.hasNext()) {
                fi.next();
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

