/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core.internal.resilience;

import org.ehcache.Cache;
import org.ehcache.CacheIterationException;
import org.ehcache.core.internal.resilience.RecoveryCache;
import org.ehcache.core.internal.resilience.RobustResilienceStrategy;
import org.ehcache.core.spi.store.StoreAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingRobustResilienceStrategy<K, V>
extends RobustResilienceStrategy<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingRobustResilienceStrategy.class);

    public LoggingRobustResilienceStrategy(RecoveryCache<K> store) {
        super(store);
    }

    @Override
    public Cache.Entry<K, V> iteratorFailure(StoreAccessException e) {
        LOGGER.error("Ehcache iterator terminated early due to exception", e);
        throw new CacheIterationException(e);
    }

    @Override
    protected void recovered(K key, StoreAccessException from) {
        LOGGER.info("Ehcache key {} recovered from", (Object)key, (Object)from);
    }

    @Override
    protected void recovered(Iterable<? extends K> keys, StoreAccessException from) {
        LOGGER.info("Ehcache keys {} recovered from", (Object)keys, (Object)from);
    }

    @Override
    protected void recovered(StoreAccessException from) {
        LOGGER.info("Ehcache recovered from", from);
    }

    @Override
    protected void inconsistent(K key, StoreAccessException because, StoreAccessException ... cleanup) {
        LOGGER.error("Ehcache key {} in possible inconsistent state due to ", (Object)key, (Object)because);
    }

    @Override
    protected void inconsistent(Iterable<? extends K> keys, StoreAccessException because, StoreAccessException ... cleanup) {
        LOGGER.error("Ehcache keys {} in possible inconsistent state due to ", (Object)keys, (Object)because);
    }

    @Override
    protected void inconsistent(StoreAccessException because, StoreAccessException ... cleanup) {
        LOGGER.error("Ehcache in possible inconsistent state due to ", because);
    }
}

