/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.colorindexer;

import it.geosolutions.jaiext.colorindexer.ColorIndexer;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.iterators.RectIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.WritableRectIter;

public class ColorIndexerOpImage
extends PointOpImage {
    public static final boolean ARRAY_CALC = true;
    public static final boolean TILE_CACHED = true;
    private ColorIndexer palette;
    private IndexColorModel icm;
    private boolean hasNoData;
    private Range nodata;
    private boolean hasROI;
    private ROI roi;
    private Rectangle roiBounds;
    private PlanarImage roiImage;
    private byte destNoData;
    private boolean caseA;
    private boolean caseB;
    private boolean caseC;
    private boolean[] lut;

    public ColorIndexerOpImage(RenderedImage image, ColorIndexer palette, ROI roi, Range nodata, int destNoData, RenderingHints hints) {
        super(image, ColorIndexerOpImage.buildLayout(image, palette.toIndexColorModel()), (Map)hints, false);
        this.icm = palette.toIndexColorModel();
        this.setSource(image, 0);
        this.palette = palette;
        boolean bl = this.hasNoData = nodata != null;
        if (this.hasNoData) {
            this.nodata = RangeFactory.convertToByteRange(nodata);
            this.initLookupTable();
        }
        boolean bl2 = this.hasROI = roi != null;
        if (this.hasROI) {
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        }
        this.destNoData = (byte)(destNoData & 0xFF);
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    private void initLookupTable() {
        this.lut = new boolean[256];
        for (int i = 0; i < 256; ++i) {
            byte b = (byte)i;
            this.lut[i] = !this.nodata.contains(b);
        }
    }

    static ImageLayout buildLayout(RenderedImage image, IndexColorModel icm) {
        ImageLayout il = new ImageLayout();
        il.setMinX(image.getMinX());
        il.setMinY(image.getMinY());
        il.setWidth(image.getWidth());
        il.setHeight(image.getHeight());
        il.setColorModel(icm);
        SampleModel sm = icm.createCompatibleSampleModel(image.getWidth(), image.getHeight());
        il.setSampleModel(sm);
        if (!(image instanceof BufferedImage)) {
            il.setTileWidth(image.getTileWidth());
            il.setTileHeight(image.getTileHeight());
            il.setTileGridXOffset(image.getTileGridXOffset());
            il.setTileGridYOffset(image.getTileGridYOffset());
        } else {
            il.setTileWidth(image.getWidth());
            il.setTileHeight(image.getHeight());
            il.setTileGridXOffset(0);
            il.setTileGridYOffset(0);
        }
        return il;
    }

    @Override
    public Raster computeTile(int tx, int ty) {
        PlanarImage sourceImage = this.getSourceImage(0);
        Raster src = sourceImage.getTile(tx, ty);
        if (src == null) {
            return null;
        }
        WritableRaster dest = this.icm.createCompatibleWritableRaster(src.getWidth(), src.getHeight()).createWritableTranslatedChild(src.getMinX(), src.getMinY());
        ROI roiTile = null;
        RandomIter roiIter = null;
        boolean roiContainsTile = false;
        Rectangle srcRect = src.getBounds();
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(srcRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = this.roi.intersect(new ROIShape(srcRectExpanded));
            if (this.roiBounds.intersects(srcRectExpanded) && !(roiContainsTile = roiTile.contains(srcRectExpanded)) && roiTile.intersects(srcRectExpanded)) {
                PlanarImage roiIMG = this.getImage();
                roiIter = RandomIterFactory.create(roiIMG, null, true, true);
            }
        }
        int w = dest.getWidth();
        int h = dest.getHeight();
        int srcMinX = Math.max(sourceImage.getMinX(), src.getMinX());
        int srcMinY = Math.max(sourceImage.getMinY(), src.getMinY());
        int srcMaxX = Math.min(sourceImage.getMinX() + sourceImage.getWidth(), src.getMinX() + w);
        int srcMaxY = Math.min(sourceImage.getMinY() + sourceImage.getHeight(), src.getMinY() + h);
        int dstMinX = Math.max(src.getMinX(), sourceImage.getMinX());
        int dstMinY = Math.max(src.getMinY(), sourceImage.getMinY());
        int srcBands = src.getNumBands();
        int[] pixel = new int[srcBands];
        int rw = srcMaxX - srcMinX;
        int rh = srcMaxY - srcMinY;
        RectIter srcIter = RectIterFactory.create(src, new Rectangle(srcMinX, srcMinY, rw, rh));
        WritableRectIter dstIter = RectIterFactory.createWritable(dest, new Rectangle(dstMinX, dstMinY, rw, rh));
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int y = srcMinY; y < srcMaxY; ++y) {
                for (int x = srcMinX; x < srcMaxX; ++x) {
                    int a;
                    int r;
                    int g;
                    int b;
                    srcIter.getPixel(pixel);
                    if (srcBands == 1 || srcBands == 2) {
                        g = b = pixel[0] & 0xFF;
                        r = b;
                        a = srcBands == 2 ? pixel[1] & 0xFF : 255;
                    } else {
                        r = pixel[0] & 0xFF;
                        g = pixel[1] & 0xFF;
                        b = pixel[2] & 0xFF;
                        a = srcBands == 4 ? pixel[3] & 0xFF : 255;
                    }
                    int idx = this.palette.getClosestIndex(r, g, b, a);
                    dstIter.setSample(idx & 0xFF);
                    if (x >= srcMaxX - 1) continue;
                    srcIter.nextPixel();
                    dstIter.nextPixel();
                }
                if (y >= srcMaxY - 1) continue;
                srcIter.nextLine();
                srcIter.startPixels();
                dstIter.nextLine();
                dstIter.startPixels();
            }
        } else if (this.caseB) {
            for (int y = srcMinY; y < srcMaxY; ++y) {
                for (int x = srcMinX; x < srcMaxX; ++x) {
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        int a;
                        int r;
                        int g;
                        int b;
                        srcIter.getPixel(pixel);
                        if (srcBands == 1 || srcBands == 2) {
                            g = b = pixel[0] & 0xFF;
                            r = b;
                            a = srcBands == 2 ? pixel[1] & 0xFF : 255;
                        } else {
                            r = pixel[0] & 0xFF;
                            g = pixel[1] & 0xFF;
                            b = pixel[2] & 0xFF;
                            a = srcBands == 4 ? pixel[3] & 0xFF : 255;
                        }
                        int idx = this.palette.getClosestIndex(r, g, b, a);
                        dstIter.setSample(0, (byte)(idx & 0xFF));
                    } else {
                        dstIter.setSample(0, this.destNoData);
                    }
                    if (x >= srcMaxX - 1) continue;
                    srcIter.nextPixel();
                    dstIter.nextPixel();
                }
                if (y >= srcMaxY - 1) continue;
                srcIter.nextLine();
                srcIter.startPixels();
                dstIter.nextLine();
                dstIter.startPixels();
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int y = srcMinY; y < srcMaxY; ++y) {
                for (int x = srcMinX; x < srcMaxX; ++x) {
                    srcIter.getPixel(pixel);
                    boolean valid = false;
                    for (int i = 0; i < srcBands; ++i) {
                        int b = pixel[i] & 0xFF;
                        valid |= this.lut[b];
                    }
                    if (valid) {
                        int a;
                        int r;
                        int g;
                        int b;
                        if (srcBands == 1 || srcBands == 2) {
                            g = b = pixel[0] & 0xFF;
                            r = b;
                            a = srcBands == 2 ? pixel[1] & 0xFF : 255;
                        } else {
                            r = pixel[0] & 0xFF;
                            g = pixel[1] & 0xFF;
                            b = pixel[2] & 0xFF;
                            a = srcBands == 4 ? pixel[3] & 0xFF : 255;
                        }
                        int idx = this.palette.getClosestIndex(r, g, b, a);
                        dstIter.setSample(0, (byte)(idx & 0xFF));
                    } else {
                        dstIter.setSample(0, this.destNoData);
                    }
                    if (x >= srcMaxX - 1) continue;
                    srcIter.nextPixel();
                    dstIter.nextPixel();
                }
                if (y >= srcMaxY - 1) continue;
                srcIter.nextLine();
                srcIter.startPixels();
                dstIter.nextLine();
                dstIter.startPixels();
            }
        } else {
            for (int y = srcMinY; y < srcMaxY; ++y) {
                for (int x = srcMinX; x < srcMaxX; ++x) {
                    if (this.roiBounds.contains(x, y) && roiIter.getSample(x, y, 0) > 0) {
                        srcIter.getPixel(pixel);
                        boolean valid = false;
                        for (int i = 0; i < srcBands; ++i) {
                            int b = pixel[i] & 0xFF;
                            valid |= this.lut[b];
                        }
                        if (valid) {
                            int a;
                            int r;
                            int g;
                            int b;
                            if (srcBands == 1 || srcBands == 2) {
                                g = b = pixel[0] & 0xFF;
                                r = b;
                                a = srcBands == 2 ? pixel[1] & 0xFF : 255;
                            } else {
                                r = pixel[0] & 0xFF;
                                g = pixel[1] & 0xFF;
                                b = pixel[2] & 0xFF;
                                a = srcBands == 4 ? pixel[3] & 0xFF : 255;
                            }
                            int idx = this.palette.getClosestIndex(r, g, b, a);
                            dstIter.setSample(0, (byte)(idx & 0xFF));
                        } else {
                            dstIter.setSample(0, this.destNoData);
                        }
                    } else {
                        dstIter.setSample(0, this.destNoData);
                    }
                    if (x >= srcMaxX - 1) continue;
                    srcIter.nextPixel();
                    dstIter.nextPixel();
                }
                if (y >= srcMaxY - 1) continue;
                srcIter.nextLine();
                srcIter.startPixels();
                dstIter.nextLine();
                dstIter.startPixels();
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlanarImage getImage() {
        PlanarImage img = this.roiImage;
        if (img == null) {
            ColorIndexerOpImage colorIndexerOpImage = this;
            synchronized (colorIndexerOpImage) {
                img = this.roiImage;
                if (img == null) {
                    this.roiImage = img = this.roi.getAsImage();
                }
            }
        }
        return img;
    }
}

