/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.imageioimpl.imagereadmt;

import it.geosolutions.imageio.imageioimpl.imagereadmt.I18N;
import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadMTCIF;
import it.geosolutions.imageio.imageioimpl.imagereadmt.ImageReadOpImageMT;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.net.URL;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import javax.imageio.event.IIOReadUpdateListener;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.CRIFImpl;
import javax.media.jai.CollectionImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PropertySource;
import javax.media.jai.WritablePropertySource;

public final class ImageReadMTCRIF
extends CRIFImpl {
    private boolean readerProvided = false;

    /*
     * Unable to fully structure code
     */
    private static ImageInputStream getImageInputStream(Object input) {
        stream = null;
        if (input instanceof ImageInputStream) {
            stream = (ImageInputStream)input;
        } else if (input instanceof String) {
            try {
                input = new RandomAccessFile((String)input, "r");
            }
            catch (Exception e) {
                input = ImageReadMTCRIF.class.getClassLoader().getResourceAsStream((String)input);
                if (input != null) ** GOTO lbl26
                throw new RuntimeException(I18N.getString("ImageReadCRIF0") + " " + input);
            }
        } else {
            if (input instanceof URL) {
                try {
                    input = ((URL)input).openStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF1") + " " + input);
                }
            }
            if (input instanceof Socket) {
                try {
                    socket = (Socket)input;
                    input = socket.getInputStream();
                }
                catch (Exception e) {
                    throw new RuntimeException(I18N.getString("ImageReadCRIF2") + " " + input);
                }
            }
        }
lbl26:
        // 7 sources

        try {
            stream = ImageIO.createImageInputStream(input);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return stream;
    }

    static ImageReader getImageReader(ParameterBlock pb) {
        Iterator<ImageReader> readers;
        Object input = pb.getObjectParameter(0);
        ImageReader reader = (ImageReader)pb.getObjectParameter(8);
        ImageInputStream stream = ImageReadMTCRIF.getImageInputStream(input);
        if (reader == null && (readers = ImageIO.getImageReaders(stream != null ? stream : input)) != null && readers.hasNext()) {
            do {
                ImageReader tmpReader = readers.next();
                ImageReaderSpi readerSpi = tmpReader.getOriginatingProvider();
                try {
                    if (!readerSpi.canDecodeInput(stream != null ? stream : input)) continue;
                    reader = tmpReader;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (reader == null && readers.hasNext());
        }
        if (reader != null) {
            EventListener[] listeners;
            Locale locale = (Locale)pb.getObjectParameter(6);
            if (locale != null) {
                reader.setLocale(locale);
            }
            if ((listeners = (EventListener[])pb.getObjectParameter(5)) != null) {
                for (int i = 0; i < listeners.length; ++i) {
                    EventListener listener = listeners[i];
                    if (listener instanceof IIOReadProgressListener) {
                        reader.addIIOReadProgressListener((IIOReadProgressListener)listener);
                    }
                    if (listener instanceof IIOReadUpdateListener) {
                        reader.addIIOReadUpdateListener((IIOReadUpdateListener)listener);
                    }
                    if (!(listener instanceof IIOReadWarningListener)) continue;
                    reader.addIIOReadWarningListener((IIOReadWarningListener)listener);
                }
            }
            boolean readMetadata = (Boolean)pb.getObjectParameter(2);
            reader.setInput(stream != null ? stream : input, false, !readMetadata);
        }
        return reader;
    }

    static void copyProperty(PropertySource ps, WritablePropertySource wps, String propertyName) {
        Object propertyValue = ps.getProperty(propertyName);
        if (propertyValue != null && !propertyValue.equals(Image.UndefinedProperty)) {
            wps.setProperty(propertyName, propertyValue);
        }
    }

    @Override
    public RenderedImage create(ParameterBlock pb, RenderingHints rh) {
        ImageReadOpImageMT image = null;
        this.readerProvided = pb.getObjectParameter(0) != null && pb.getObjectParameter(0) instanceof ImageReader;
        ImageReader reader = ImageReadMTCRIF.getImageReader(pb);
        if (reader != null) {
            int imageIndex = pb.getIntParameter(1);
            ImageReadParam param = (ImageReadParam)pb.getObjectParameter(7);
            boolean readThumbnails = (Boolean)pb.getObjectParameter(3);
            ImageLayout layout = rh != null && rh.containsKey(JAI.KEY_IMAGE_LAYOUT) ? (ImageLayout)rh.get(JAI.KEY_IMAGE_LAYOUT) : new ImageLayout();
            try {
                Object paramInput = pb.getObjectParameter(0);
                Object readerInput = reader.getInput();
                ImageInputStream streamToClose = null;
                if (readerInput != paramInput && readerInput instanceof ImageInputStream) {
                    streamToClose = (ImageInputStream)readerInput;
                }
                image = new ImageReadOpImageMT(layout, rh, param, reader, imageIndex, readThumbnails, streamToClose, this.readerProvided);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return image;
    }

    public RenderableImage createRenderable(ParameterBlock pb, RenderingHints rh) {
        CollectionImage sequence = ImageReadMTCIF.createStatic(pb, rh);
        TreeMap<Dimension, RenderedImage> sourceMap = new TreeMap<Dimension, RenderedImage>(new Comparator(){

            public int compare(Object o1, Object o2) {
                double inverse2;
                Dimension d1 = (Dimension)o1;
                Dimension d2 = (Dimension)o2;
                int area1 = d1.width * d1.height;
                int area2 = d2.width * d2.height;
                double inverse1 = area1 == 0 ? Double.MAX_VALUE : 1.0 / (double)area1;
                double d = inverse2 = area2 == 0 ? Double.MAX_VALUE : 1.0 / (double)area2;
                if (inverse1 < inverse2) {
                    return -1;
                }
                if (inverse1 > inverse2) {
                    return 1;
                }
                return 0;
            }

            public boolean equals(Object o1, Object o2) {
                return o1.equals(o2);
            }
        });
        for (RenderedImage image : sequence) {
            sourceMap.put(new Dimension(image.getWidth(), image.getHeight()), image);
        }
        Vector renderedSources = new Vector(sourceMap.size());
        Iterator keys = sourceMap.keySet().iterator();
        while (keys.hasNext()) {
            renderedSources.add(sourceMap.get(keys.next()));
        }
        MultiResolutionRenderableImage renderableImage = new MultiResolutionRenderableImage(renderedSources, 0.0f, 0.0f, 1.0f);
        PropertySource firstSource = (PropertySource)renderedSources.get(0);
        ImageReadMTCRIF.copyProperty(firstSource, renderableImage, "JAI.ImageReadParam");
        ImageReadMTCRIF.copyProperty(firstSource, renderableImage, "JAI.ImageReader");
        ImageReadMTCRIF.copyProperty(firstSource, renderableImage, "JAI.StreamMetadata");
        ImageReadMTCRIF.copyProperty(firstSource, renderableImage, "JAI.ImageMetadata");
        return renderableImage;
    }

    @Override
    public RenderedImage create(RenderContext rc, ParameterBlock pb) {
        RenderableImage renderableImage = this.createRenderable(pb, rc.getRenderingHints());
        RenderedImage renderedImage = renderableImage.createRendering(rc);
        ((WritablePropertySource)((Object)renderedImage)).setProperty("JAI.RenderableInput", (PropertySource)((Object)renderableImage));
        return renderedImage;
    }

    @Override
    public Rectangle2D getBounds2D(ParameterBlock pb) {
        RenderableImage renderable = this.createRenderable(pb, null);
        return new Rectangle2D.Float(renderable.getMinX(), renderable.getMinY(), renderable.getWidth(), renderable.getHeight());
    }
}

