/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.OperationNotSupportedException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.XMLHandlerHints;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterEncodingPreProcessor;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FilterOpsComplexTypes {
    private static final int SPATIAL_TYPE = 0;
    private static final int COMPARE_TYPE = 1;
    private static final int LOGIC_TYPE = 2;
    private static final int FID_TYPE = 3;

    protected static void encodeFilter(Filter filter, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        if (filter instanceof BinaryLogicOperator) {
            FilterType.elems[2].getType().encode(FilterType.elems[2], filter, output, hints);
        } else if (filter instanceof Not) {
            FilterType.elems[2].getType().encode(FilterType.elems[2], filter, output, hints);
        } else if (filter instanceof BinaryComparisonOperator) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof PropertyIsBetween) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof Id) {
            FilterType.elems[3].getType().encode(FilterType.elems[3], filter, output, hints);
        } else if (filter instanceof BinarySpatialOperator) {
            FilterType.elems[0].getType().encode(FilterType.elems[0], filter, output, hints);
        } else if (filter instanceof PropertyIsLike) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else if (filter instanceof PropertyIsNull) {
            FilterType.elems[1].getType().encode(FilterType.elems[1], filter, output, hints);
        } else {
            throw new OperationNotSupportedException("The Filter type is not known: please try again. " + filter == null ? "null" : filter.getClass().getName());
        }
    }

    protected static void encodeExpr(Expression expr, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException, IOException {
        int i = 0;
        switch (Filters.getExpressionType(expr)) {
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                i = 36;
                break;
            }
            case 105: {
                i = 29;
                break;
            }
            case 106: {
                i = 30;
                break;
            }
            case 107: {
                i = 31;
                break;
            }
            case 108: {
                i = 32;
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 115: {
                i = 34;
                break;
            }
            case 114: {
                i = 35;
            }
        }
        if (i != 0) {
            FilterSchema.getInstance().getElements()[i].getType().encode(FilterSchema.getInstance().getElements()[i], expr, output, hints);
        }
    }

    public static class UnaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UnaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return choice;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if (!("and".equalsIgnoreCase(name) || "or".equalsIgnoreCase(name) || "not".equalsIgnoreCase(name))) {
                throw new SAXException("Expected AND or OR logic filter");
            }
            if (value == null || value.length != 1) {
                throw new SAXException("Require a single filter for " + element);
            }
            try {
                Filter filter = (Filter)value[0].getValue();
                return factory.not(filter);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Require a single filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "UnaryLogicOpType";
        }

        @Override
        public Class getInstanceType() {
            return Not.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Not;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Not lf = (Not)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeFilter(lf.getFilter(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryLogicOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinaryLogicOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance())};
        private static Choice choice = new ChoiceGT(null, 2, Integer.MAX_VALUE, elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return LogicOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return choice;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            int type;
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            String name = element.getName();
            if ("and".equalsIgnoreCase(name)) {
                type = 2;
            } else if ("or".equalsIgnoreCase(name)) {
                type = 1;
            } else {
                throw new SAXException("Expected AND or OR logic filter");
            }
            try {
                ArrayList<Filter> children = new ArrayList<Filter>(value.length);
                HashSet<Identifier> ids = new HashSet<Identifier>(value.length);
                boolean fidOnly = true;
                for (ElementValue elementValue : value) {
                    Filter filter = (Filter)((Object)elementValue);
                    if (filter instanceof Id) {
                        Id id = (Id)filter;
                        ids.addAll(id.getIdentifiers());
                    } else {
                        fidOnly = false;
                    }
                    children.add(filter);
                }
                if (type == 1) {
                    if (fidOnly) {
                        return factory.id(ids);
                    }
                    return factory.or(children);
                }
                return factory.and(children);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "BinaryLogicOpType";
        }

        @Override
        public Class getInstanceType() {
            return BinaryLogicOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BinaryLogicOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BinaryLogicOperator lf = (BinaryLogicOperator)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            for (Filter f : lf.getChildren()) {
                FilterOpsComplexTypes.encodeFilter(f, output, hints);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("units", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isMixed() {
            return true;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression geometry1 = (Expression)value[0].getValue();
                Expression geometry2 = (Expression)value[1].getValue();
                Literal literal = (Literal)((Object)value[2]);
                double distance = ((Number)literal.getValue()).doubleValue();
                return factory.dwithin(geometry1, geometry2, distance, null);
            }
            catch (ClassCastException | IllegalFilterException wrong) {
                throw new SAXException(wrong);
            }
        }

        @Override
        public String getName() {
            return "DistanceType";
        }

        @Override
        public Class getInstanceType() {
            return DistanceBufferOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600L) != 1536L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof DistanceBufferOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            DistanceBufferOperator distanceFilter = (DistanceBufferOperator)value;
            AttributesImpl ai = new AttributesImpl();
            String name = attrs[0].getName();
            String uri = this.getNamespace().toString();
            if (Filters.getExpressionType(distanceFilter.getExpression1()) == 104) {
                Geometry geometry = distanceFilter.getExpression1().evaluate(null, Geometry.class);
                if (geometry.getUserData() != null) {
                    String srsName = String.valueOf(geometry.getUserData());
                    ai.addAttribute(uri, name, null, "string", srsName);
                }
            } else {
                Geometry geometry = distanceFilter.getExpression2().evaluate(null, Geometry.class);
                if (geometry.getUserData() != null) {
                    String srsName = String.valueOf(geometry.getUserData());
                    ai.addAttribute(uri, name, null, "string", srsName);
                }
            }
            output.startElement(element.getNamespace(), element.getName(), null);
            output.characters("" + distanceFilter.getDistance());
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class DistanceBufferType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new DistanceBufferType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], new FilterSchema.FilterElement("Distance", DistanceType.getInstance())};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return this.seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression geometry1 = (Expression)value[0].getValue();
                Expression geometry2 = (Expression)value[1].getValue();
                Literal literal = (Literal)((Object)value[2]);
                double distance = ((Number)literal.getValue()).doubleValue();
                return factory.beyond(geometry1, geometry2, distance, null);
            }
            catch (ClassCastException | IllegalFilterException wrong) {
                throw new SAXException(wrong);
            }
        }

        @Override
        public String getName() {
            return "DistanceBufferType";
        }

        @Override
        public Class getInstanceType() {
            return DistanceBufferOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 0x600L) != 1536L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof DistanceBufferOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            DistanceBufferOperator lf = (DistanceBufferOperator)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            if (Filters.getExpressionType(lf.getExpression1()) == 113) {
                elems[0].getType().encode(elems[0], lf.getExpression1(), output, hints);
                elems[1].getType().encode(elems[1], lf.getExpression2().evaluate(null, Geometry.class), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else if (Filters.getExpressionType(lf.getExpression2()) == 113) {
                elems[0].getType().encode(elems[0], lf.getExpression2(), output, hints);
                elems[1].getType().encode(elems[1], lf.getExpression1().evaluate(null, Geometry.class), output, hints);
                elems[2].getType().encode(elems[2], lf, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BBOXType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BBOXType();
        private static final Element OGC_PROPERTY_NAME = new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance());
        private static final Element GML_BOX = GMLSchema.getInstance().getElements()[41];
        private static Element[] elems = new Element[]{OGC_PROPERTY_NAME, GML_BOX};
        private Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return this.seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            if (value == null || value.length != 2) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter");
            }
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Object literal;
                Expression geometry1 = (Expression)value[0].getValue();
                Expression geometry2 = (Expression)value[1].getValue();
                if (geometry2 instanceof Literal && (literal = ((Literal)geometry2).getValue()) instanceof Geometry) {
                    Geometry geometry = (Geometry)literal;
                    Envelope env = geometry.getEnvelopeInternal();
                    return factory.bbox(geometry1, env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), null);
                }
                Disjoint disjoint = factory.disjoint(geometry1, geometry2);
                return factory.not(disjoint);
            }
            catch (ClassCastException wrong) {
                throw new SAXException("ogc:propertyName or gml:box required for bbox filter", wrong);
            }
            catch (IllegalFilterException illegalFilterException) {
                throw new SAXException("Could not create bbox filter", illegalFilterException);
            }
        }

        @Override
        public String getName() {
            return "BBOXType";
        }

        @Override
        public Class getInstanceType() {
            return Filter.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() & 1L) != 1L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BinarySpatialOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BinarySpatialOperator lf = (BinarySpatialOperator)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            short TYPE1 = Filters.getExpressionType(lf.getExpression1());
            short TYPE2 = Filters.getExpressionType(lf.getExpression2());
            if (TYPE1 == 104) {
                elems[0].getType().encode(elems[0], lf.getExpression2(), output, hints);
                Geometry g = ((Geometry)((Literal)lf.getExpression1()).getValue()).getEnvelope();
                elems[1].getType().encode(elems[1], g, output, hints);
            } else if (TYPE2 == 104) {
                elems[0].getType().encode(elems[0], lf.getExpression1(), output, hints);
                ReferencedEnvelope re = (ReferencedEnvelope)((Literal)lf.getExpression2()).getValue();
                elems[1].getType().encode(elems[1], re, output, hints);
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name : BBOXType");
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinarySpatialOpType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new BinarySpatialOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), GMLSchema.getInstance().getElements()[29], GMLSchema.getInstance().getElements()[41]};
        private static Sequence child = new SequenceGT(new ElementGrouping[]{elems[0], new ChoiceGT(new Element[]{elems[1], elems[2]})});

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return SpatialOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return child;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                short type = SpatialOpsType.findFilterType(element.getName());
                Expression geometry1 = (Expression)value[0].getValue();
                Expression geometry2 = (Expression)value[1].getValue();
                switch (type) {
                    case 5: {
                        return factory.equal(geometry1, geometry2);
                    }
                    case 6: {
                        return factory.disjoint(geometry1, geometry2);
                    }
                    case 7: {
                        return factory.intersects(geometry1, geometry2);
                    }
                    case 9: {
                        return factory.crosses(geometry1, geometry2);
                    }
                    case 10: {
                        return factory.within(geometry1, geometry2);
                    }
                    case 11: {
                        return factory.contains(geometry1, geometry2);
                    }
                    case 12: {
                        return factory.overlaps(geometry1, geometry2);
                    }
                    case 8: {
                        return factory.touches(geometry1, geometry2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "BinarySpatialOpType";
        }

        @Override
        public Class getInstanceType() {
            return BinarySpatialOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities")) {
                FilterCapabilities fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities");
                FilterCapabilities elementkey = FilterCapabilities.findOperation(element.getName());
                if (elementkey == null || !fc.supports(elementkey)) {
                    return false;
                }
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BinarySpatialOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BinarySpatialOperator lf = (BinarySpatialOperator)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            short type1 = Filters.getExpressionType(lf.getExpression1());
            short type2 = Filters.getExpressionType(lf.getExpression2());
            if (type1 == 103 || type1 == 111 || type1 == 113) {
                elems[0].getType().encode(elems[0], lf.getExpression1(), output, hints);
                if (type2 == 104) {
                    elems[1].getType().encode(elems[1], ((Literal)lf.getExpression2()).getValue(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((Literal)lf.getExpression2()).getValue(), output, hints);
                }
            } else if (type2 == 103 || type2 == 111 || type2 == 113) {
                elems[0].getType().encode(elems[0], lf.getExpression2(), output, hints);
                if (type1 == 104) {
                    elems[1].getType().encode(elems[1], ((Literal)lf.getExpression1()).getValue(), output, hints);
                } else {
                    elems[2].getType().encode(elems[2], ((Literal)lf.getExpression1()).getValue(), output, hints);
                }
            } else {
                throw new OperationNotSupportedException("Either the left or right expr must be a literal for the property name l=" + type1 + " r=" + type2);
            }
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class UpperBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new UpperBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Sequence choice = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public ElementGrouping getChild() {
            return choice;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) {
            return value[0].getValue();
        }

        @Override
        public String getName() {
            return "UpperBoundaryType";
        }

        @Override
        public Class getInstanceType() {
            return Expression.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Expression;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Expression lf = (Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class LowerBoundaryType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new LowerBoundaryType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance())};
        private static Choice choice = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public ElementGrouping getChild() {
            return choice;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) {
            return value[0].getValue();
        }

        @Override
        public String getName() {
            return "LowerBoundaryType";
        }

        @Override
        public Class getInstanceType() {
            return Expression.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Expression;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Expression lf = (Expression)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf, output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsBetweenType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsBetweenType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()), new FilterSchema.FilterElement("LowerBoundary", LowerBoundaryType.getInstance()), new FilterSchema.FilterElement("UpperBoundary", UpperBoundaryType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression left = (Expression)value[1].getValue();
                Expression middle = (Expression)value[0].getValue();
                Expression right = (Expression)value[2].getValue();
                return factory.between(middle, left, right);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "PropertyIsBetweenType";
        }

        @Override
        public Class getInstanceType() {
            return PropertyIsBetween.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x1000L) != 4096L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof PropertyIsBetween;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            PropertyIsBetween lf = (PropertyIsBetween)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(lf.getExpression(), output, hints);
            elems[1].getType().encode(elems[1], lf.getLowerBoundary(), output, hints);
            elems[2].getType().encode(elems[2], lf.getUpperBoundary(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsNullType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsNullType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Choice seq = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression expr = (Expression)value[0].getValue();
                return factory.isNull(expr);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "PropertyIsNullType";
        }

        @Override
        public Class getInstanceType() {
            return PropertyIsNull.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x2000L) != 8192L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof PropertyIsNull;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            PropertyIsNull lf = (PropertyIsNull)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            elems[0].getType().encode(elems[0], lf.getExpression(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class PropertyIsLikeType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new PropertyIsLikeType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("PropertyName", FilterComplexTypes.PropertyNameType.getInstance()), new FilterSchema.FilterElement("Literal", FilterComplexTypes.LiteralType.getInstance())};
        private static Sequence seq = new SequenceGT(elems);
        private static Attribute[] attr = new Attribute[]{new FilterSchema.FilterAttribute("wildCard", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("singleChar", XSISimpleTypes.String.getInstance(), 2), new FilterSchema.FilterAttribute("escape", XSISimpleTypes.String.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Attribute[] getAttributes() {
            return attr;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression expr = (Expression)value[0].getValue();
                String wildCard = attrs.getValue("wildCard");
                String singleChar = attrs.getValue("singleChar");
                String escape = attrs.getValue("escape");
                Literal pattern = (Literal)value[1].getValue();
                return factory.like(expr, (String)pattern.getValue(), wildCard, singleChar, escape);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "PropertyIsLikeType";
        }

        @Override
        public Class getInstanceType() {
            return PropertyIsLike.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x800L) != 2048L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof PropertyIsLike;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            PropertyIsLike lf = (PropertyIsLike)value;
            AttributesImpl at = new AttributesImpl();
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "wildCard", null, "string", lf.getWildCard());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "singleChar", null, "string", lf.getSingleChar());
            at.addAttribute(FilterSchema.NAMESPACE.toString(), "escape", null, "string", lf.getEscape());
            output.startElement(element.getNamespace(), element.getName(), at);
            elems[0].getType().encode(elems[0], lf.getExpression(), output, hints);
            elems[1].getType().encode(elems[1], lf.getLiteral(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class BinaryComparisonOpType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new BinaryComparisonOpType();
        private static Element[] elems = new Element[]{new FilterSchema.FilterElement("expression", FilterComplexTypes.ExpressionType.getInstance()){

            @Override
            public int getMaxOccurs() {
                return 2;
            }

            @Override
            public int getMinOccurs() {
                return 2;
            }
        }};
        private static Sequence seq = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Type getParent() {
            return ComparisonOpsType.getInstance();
        }

        @Override
        public ElementGrouping getChild() {
            return seq;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException, OperationNotSupportedException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                short type = ComparisonOpsType.findFilterType(element.getName());
                Expression expr1 = (Expression)value[0].getValue();
                Expression expr2 = (Expression)value[1].getValue();
                switch (type) {
                    case 14: {
                        return factory.equals(expr1, expr2);
                    }
                    case 23: {
                        return factory.notEqual(expr1, expr2);
                    }
                    case 16: {
                        return factory.greater(expr1, expr2);
                    }
                    case 18: {
                        return factory.greaterOrEqual(expr1, expr2);
                    }
                    case 15: {
                        return factory.less(expr1, expr2);
                    }
                    case 17: {
                        return factory.lessOrEqual(expr1, expr2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException expressionRequired) {
                throw new SAXException("Illegal filter for " + element, expressionRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "BinaryComparisonOpType";
        }

        @Override
        public Class getInstanceType() {
            return BinaryComparisonOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3F4000L) != 4145152L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BinaryComparisonOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BinaryComparisonOperator cf = (BinaryComparisonOperator)value;
            output.startElement(element.getNamespace(), element.getName(), null);
            FilterOpsComplexTypes.encodeExpr(cf.getExpression1(), output, hints);
            FilterOpsComplexTypes.encodeExpr(cf.getExpression2(), output, hints);
            output.endElement(element.getNamespace(), element.getName());
        }
    }

    public static class FeatureIdType
    extends FilterSchema.FilterComplexType {
        private static final ComplexType instance = new FeatureIdType();
        private static Attribute[] attrs = new Attribute[]{new FilterSchema.FilterAttribute("fid", XSISimpleTypes.AnyURI.getInstance(), 2)};

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Attribute[] getAttributes() {
            return attrs;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws SAXException, SAXNotSupportedException {
            if (element == null || value == null || element.getType() == null) {
                throw new SAXException("Invalid parameters : null found");
            }
            if (value.length != 0) {
                throw new SAXException("Invalid children: more than 0 ... " + value.length);
            }
            if (!this.getName().equals(element.getType().getName())) {
                throw new SAXException("Invalid type name for element provided");
            }
            String fid = attrs1.getValue("", attrs[0].getName());
            if (fid == null || "".equals(fid)) {
                fid = attrs1.getValue(attrs[0].getNamespace().toString(), attrs[0].getName());
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            HashSet<FeatureId> fids = new HashSet<FeatureId>();
            fids.add(ff.featureId(fid));
            return ff.id(fids);
        }

        @Override
        public String getName() {
            return "FeatureIdType";
        }

        @Override
        public Class getInstanceType() {
            return Id.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof Id;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Id ff = (Id)value;
            Set<Object> fids = ff.getIDs();
            AttributesImpl att = new AttributesImpl();
            att.addAttribute(null, null, null, null, null);
            output.startElement(element.getNamespace(), "Filter", null);
            for (String string : fids) {
                att.setAttribute(0, element.getNamespace().toString(), attrs[0].getName(), null, "anyUri", string);
                output.element(element.getNamespace(), element.getName(), att);
            }
            output.endElement(element.getNamespace(), "Filter");
        }
    }

    public static class FilterType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        static final Element[] elems = new Element[]{new FilterSchema.FilterElement("spatialOps", SpatialOpsType.getInstance()), new FilterSchema.FilterElement("comparisonOps", ComparisonOpsType.getInstance()), new FilterSchema.FilterElement("logicOps", LogicOpsType.getInstance()), new FilterSchema.FilterElement("FeatureId", FeatureIdType.getInstance()){

            @Override
            public int getMaxOccurs() {
                return Integer.MAX_VALUE;
            }
        }};
        private static Choice choice = new ChoiceGT(elems);
        private static final ComplexType instance = new FilterType();

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public ElementGrouping getChild() {
            return choice;
        }

        @Override
        public Element[] getChildElements() {
            return elems;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) {
            if (value.length == 1) {
                return value[0].getValue();
            }
            if (value.length == 0) {
                return Filter.EXCLUDE;
            }
            try {
                FilterFactory2 fac = CommonFactoryFinder.getFilterFactory2(null);
                ArrayList<Filter> filters = new ArrayList<Filter>();
                HashSet<Identifier> ids = new HashSet<Identifier>();
                boolean isOnlyFids = true;
                for (ElementValue elementValue : value) {
                    Filter value2 = (Filter)elementValue.getValue();
                    if (value2 == Filter.EXCLUDE) continue;
                    if (value2 instanceof Id) {
                        Id idFilter = (Id)value2;
                        ids.addAll(idFilter.getIdentifiers());
                    } else {
                        isOnlyFids = false;
                    }
                    filters.add(value2);
                }
                if (isOnlyFids && !ids.isEmpty()) {
                    return fac.id(ids);
                }
                if (filters.isEmpty()) {
                    return Filter.EXCLUDE;
                }
                if (filters.size() == 1) {
                    return filters.iterator().next();
                }
                return fac.or(filters);
            }
            catch (IllegalFilterException e) {
                return value[0].getValue();
            }
        }

        @Override
        public String getName() {
            return "FilterType";
        }

        @Override
        public Class getInstanceType() {
            return Filter.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() == 0L && fc.getSpatialOps() == 0L) {
                return false;
            }
            boolean r = element != null && element.getType() != null && this.getName().equals(element.getType().getName());
            r = r && value != null && value instanceof Filter;
            return r;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            if (value == null) {
                return;
            }
            if (value == Filter.INCLUDE) {
                return;
            }
            if (value == Filter.EXCLUDE) {
                return;
            }
            Filter filter = (Filter)value;
            if (element != null) {
                output.startElement(element.getNamespace(), element.getName(), null);
            }
            FilterEncodingPreProcessor visitor = this.getFilterEncodingPreProcessor(hints);
            filter.accept(visitor, null);
            if (!visitor.getFilter().equals(Filter.EXCLUDE)) {
                FilterOpsComplexTypes.encodeFilter(visitor.getFilter(), output, hints);
            }
            if (!visitor.getFidFilter().getIDs().isEmpty()) {
                FilterOpsComplexTypes.encodeFilter(visitor.getFidFilter(), output, hints);
            }
            if (element != null) {
                output.endElement(element.getNamespace(), element.getName());
            }
        }

        private FilterEncodingPreProcessor getFilterEncodingPreProcessor(Map<String, Object> hints) {
            if (hints != null && hints.containsKey("org.geotools.xml.filter.FILTER_COMPLIANCE_STRICTNESS")) {
                return new FilterEncodingPreProcessor((Integer)hints.get("org.geotools.xml.filter.FILTER_COMPLIANCE_STRICTNESS"));
            }
            return new FilterEncodingPreProcessor(XMLHandlerHints.VALUE_FILTER_COMPLIANCE_LOW);
        }
    }

    public static class LogicOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new LogicOpsType();

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) {
            return null;
        }

        @Override
        public String getName() {
            return "LogicOpsType";
        }

        @Override
        public Class getInstanceType() {
            return BinaryLogicOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3800000L) != 0x3800000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && (value instanceof BinaryLogicOperator || value instanceof Not);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            if (value instanceof And) {
                BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("And", BinaryLogicOpType.getInstance(), element), value, output, hints);
            } else if (value instanceof Or) {
                BinaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Or", BinaryLogicOpType.getInstance(), element), value, output, hints);
            } else if (value instanceof Not) {
                UnaryLogicOpType.getInstance().encode(new FilterSchema.FilterElement("Not", UnaryLogicOpType.getInstance(), element), value, output, hints);
            } else {
                throw new OperationNotSupportedException("Unknown filter type in LogicFilter: " + value.getClass().getName());
            }
        }

        @Override
        public boolean isAbstract() {
            return true;
        }
    }

    public static class SpatialOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new SpatialOpsType();

        public static short findFilterType(String s) {
            if ("BBOX".equalsIgnoreCase(s)) {
                return 4;
            }
            if ("Equals".equalsIgnoreCase(s)) {
                return 5;
            }
            if ("Disjoint".equalsIgnoreCase(s)) {
                return 6;
            }
            if ("Intersects".equalsIgnoreCase(s)) {
                return 7;
            }
            if ("Touches".equalsIgnoreCase(s)) {
                return 8;
            }
            if ("Crosses".equalsIgnoreCase(s)) {
                return 9;
            }
            if ("Within".equalsIgnoreCase(s)) {
                return 10;
            }
            if ("Contains".equalsIgnoreCase(s)) {
                return 11;
            }
            if ("Overlaps".equalsIgnoreCase(s)) {
                return 12;
            }
            if ("Beyond".equalsIgnoreCase(s)) {
                return 13;
            }
            if ("DWithin".equalsIgnoreCase(s)) {
                return 24;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 4: {
                    return "BBOX";
                }
                case 5: {
                    return "Equals";
                }
                case 6: {
                    return "Disjoint";
                }
                case 7: {
                    return "Intersects";
                }
                case 8: {
                    return "Touches";
                }
                case 9: {
                    return "Crosses";
                }
                case 10: {
                    return "Within";
                }
                case 11: {
                    return "Contains";
                }
                case 12: {
                    return "Overlaps";
                }
                case 13: {
                    return "Beyond";
                }
                case 24: {
                    return "DWithin";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            return null;
        }

        @Override
        public String getName() {
            return "SpatialOpsType";
        }

        @Override
        public Class getInstanceType() {
            return BinarySpatialOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && (fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getSpatialOps() == 0L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && value instanceof BinarySpatialOperator;
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            BinarySpatialOperator lf = (BinarySpatialOperator)value;
            if (lf instanceof BBOX) {
                BBOXType.getInstance().encode(new FilterSchema.FilterElement("BBOX", BBOXType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Beyond) {
                DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("Beyond", DistanceBufferType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Contains) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Contains", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Crosses) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Crosses", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Disjoint) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Disjoint", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof DWithin) {
                DistanceBufferType.getInstance().encode(new FilterSchema.FilterElement("DWithin", DistanceBufferType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Equals) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Equals", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Intersects) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Intersects", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Overlaps) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Overlaps", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Touches) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Touches", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof Within) {
                BinarySpatialOpType.getInstance().encode(new FilterSchema.FilterElement("Within", BinarySpatialOpType.getInstance(), element), value, output, hints);
            } else {
                throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
            }
        }
    }

    public static class ComparisonOpsType
    extends FilterSchema.FilterComplexType
    implements org.geotools.filter.FilterType {
        private static final ComplexType instance = new ComparisonOpsType();

        public static short findFilterType(String s) {
            if ("PropertyIsEqualTo".equalsIgnoreCase(s)) {
                return 14;
            }
            if ("PropertyIsGreaterThan".equalsIgnoreCase(s)) {
                return 16;
            }
            if ("PropertyIsGreaterThanOrEqualTo".equalsIgnoreCase(s)) {
                return 18;
            }
            if ("PropertyIsLessThan".equalsIgnoreCase(s)) {
                return 15;
            }
            if ("PropertyIsLessThanOrEqualTo".equalsIgnoreCase(s)) {
                return 17;
            }
            if ("PropertyIsNotEqualTo".equalsIgnoreCase(s)) {
                return 23;
            }
            if ("PropertyIsLike".equalsIgnoreCase(s)) {
                return 20;
            }
            if ("PropertyIsNull".equalsIgnoreCase(s)) {
                return 21;
            }
            if ("PropertyIsBetween".equalsIgnoreCase(s)) {
                return 19;
            }
            return 0;
        }

        public static String writeFilterType(short filterType) {
            switch (filterType) {
                case 14: {
                    return "PropertyIsEqualTo";
                }
                case 16: {
                    return "PropertyIsGreaterThan";
                }
                case 18: {
                    return "PropertyIsGreaterThanOrEqualTo";
                }
                case 15: {
                    return "PropertyIsLessThan";
                }
                case 17: {
                    return "PropertyIsLessThanOrEqualTo";
                }
                case 23: {
                    return "PropertyIsNotEqualTo";
                }
                case 20: {
                    return "PropertyIsLike";
                }
                case 21: {
                    return "PropertyIsNull";
                }
                case 19: {
                    return "PropertyIsBetween";
                }
            }
            return "";
        }

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public boolean isAbstract() {
            return true;
        }

        @Override
        public ElementGrouping getChild() {
            return null;
        }

        @Override
        public Element[] getChildElements() {
            return null;
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs, Map<String, Object> hints) throws SAXException {
            FilterFactory2 factory = FilterSchema.filterFactory(hints);
            try {
                Expression expr1 = (Expression)value[0].getValue();
                Expression expr2 = (Expression)value[1].getValue();
                short type = ComparisonOpsType.findFilterType(element.getName());
                switch (type) {
                    case 14: {
                        return factory.equals(expr1, expr2);
                    }
                    case 16: {
                        return factory.greater(expr1, expr2);
                    }
                    case 18: {
                        return factory.greaterOrEqual(expr1, expr2);
                    }
                    case 15: {
                        return factory.less(expr1, expr2);
                    }
                    case 17: {
                        return factory.lessOrEqual(expr1, expr2);
                    }
                    case 23: {
                        return factory.notEqual(expr1, expr2);
                    }
                }
                throw new SAXException("Illegal filter for " + element);
            }
            catch (ClassCastException filterRequired) {
                throw new SAXException("Illegal filter for " + element, filterRequired);
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Illegal filter for " + element);
            }
        }

        @Override
        public String getName() {
            return "ComparisonOpsType";
        }

        @Override
        public Class getInstanceType() {
            return BinaryComparisonOperator.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            FilterCapabilities fc;
            if (hints != null && hints.containsKey("FilterSchema.FilterCapabilities") && ((fc = (FilterCapabilities)hints.get("FilterSchema.FilterCapabilities")).getScalarOps() & 0x3F0000L) != 0x3F0000L) {
                return false;
            }
            return element.getType() != null && this.getName().equals(element.getType().getName()) && (value instanceof BinaryComparisonOperator || value instanceof PropertyIsBetween || value instanceof PropertyIsNull || value instanceof PropertyIsLike);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws IOException, OperationNotSupportedException {
            if (!this.canEncode(element, value, hints)) {
                return;
            }
            Filter lf = (Filter)value;
            if (lf instanceof PropertyIsEqualTo) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsGreaterThan) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsGreaterThanOrEqualTo) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsGreaterThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsLessThan) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThan", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsLessThanOrEqualTo) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLessThanOrEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsNotEqualTo) {
                BinaryComparisonOpType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNotEqualTo", BinaryComparisonOpType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsLike) {
                PropertyIsLikeType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsLike", PropertyIsLikeType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsNull) {
                PropertyIsNullType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsNull", PropertyIsNullType.getInstance(), element), value, output, hints);
            } else if (lf instanceof PropertyIsBetween) {
                PropertyIsBetweenType.getInstance().encode(new FilterSchema.FilterElement("PropertyIsBetween", PropertyIsBetweenType.getInstance(), element), value, output, hints);
            } else {
                throw new OperationNotSupportedException("Unknown filter type in ComparisonFilter: " + lf.getClass().getName());
            }
        }
    }
}

