/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.xml.filter.UnsupportedFilterException;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.SpatialOperator;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.BinaryTemporalOperator;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class FilterEncodingPreProcessor
implements FilterVisitor {
    private static final int LOW = 0;
    private static final int MEDIUM = 1;
    private static final int HIGH = 2;
    private int complianceInt;
    private Stack<Data> current = new Stack();
    FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    private boolean requiresPostProcessing = false;

    public FilterEncodingPreProcessor(Integer complianceLevel) {
        if (complianceLevel != 0 && complianceLevel != 1 && complianceLevel != 2) {
            throw new IllegalArgumentException("compliance level must be one of: XMLHandlerHints.VALUE_FILTER_COMPLIANCE_LOOSE XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MEDIUM or XMLHandlerHints.VALUE_FILTER_COMPLIANCE_MAXIMUM");
        }
        this.complianceInt = complianceLevel;
    }

    public Id getFidFilter() {
        if (this.current.isEmpty()) {
            Set empty = Collections.emptySet();
            return this.ff.id(empty);
        }
        Data data = this.current.peek();
        if (data.fids.isEmpty()) {
            Set empty = Collections.emptySet();
            return this.ff.id(empty);
        }
        HashSet<FeatureId> set = new HashSet<FeatureId>();
        Set fids = data.fids;
        for (String fid : fids) {
            set.add(this.ff.featureId(fid));
        }
        return this.ff.id(set);
    }

    public Filter getFilter() {
        if (this.current.isEmpty()) {
            return Filter.EXCLUDE;
        }
        return this.current.peek().filter;
    }

    public void visit(Filter filter) {
        if (filter instanceof PropertyIsBetween || filter instanceof BinaryComparisonOperator || filter instanceof BinarySpatialOperator || filter instanceof PropertyIsLike || filter instanceof BinaryLogicOperator || filter instanceof Not || filter instanceof PropertyIsNull || filter instanceof Id) {
            filter.accept(this, null);
        } else {
            this.current.push(new Data(filter));
        }
    }

    public void visit(PropertyIsBetween filter) {
        this.current.push(new Data(filter));
    }

    public void visit(BinaryComparisonOperator filter) {
        this.current.push(new Data(filter));
    }

    public void visit(Not filter) {
        this.current.push(new Data(filter));
    }

    public void visit(BinarySpatialOperator filter) {
        this.current.push(new Data(filter));
    }

    public void visit(PropertyIsLike filter) {
        this.current.push(new Data(filter));
    }

    public void visitLogicFilter(Not filter) {
        int startSize = this.current.size();
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data(filter));
                    break;
                }
                case 1: {
                    filter.getFilter().accept(this, null);
                    this.current.push(this.createMediumLevelLogicFilter(filter, startSize));
                    break;
                }
                case 2: {
                    filter.getFilter().accept(this, null);
                    this.current.push(this.createHighLevelLogicFilter(filter, startSize));
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
    }

    public void visit(BinaryLogicOperator filter) {
        int startSize = this.current.size();
        try {
            switch (this.complianceInt) {
                case 0: {
                    this.current.push(new Data(filter));
                    break;
                }
                case 1: {
                    for (Filter component : filter.getChildren()) {
                        component.accept(this, null);
                    }
                    this.current.push(this.createMediumLevelLogicFilter(filter, startSize));
                    break;
                }
                case 2: {
                    for (Filter component : filter.getChildren()) {
                        component.accept(this, null);
                    }
                    this.current.push(this.createHighLevelLogicFilter(filter, startSize));
                    break;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof UnsupportedFilterException) {
                throw (UnsupportedFilterException)e;
            }
            throw new UnsupportedFilterException("Exception creating filter", e);
        }
    }

    private Data createMediumLevelLogicFilter(Filter filter, int startOfFilterStack) throws IllegalFilterException {
        Data resultingFilter;
        if (filter instanceof And) {
            Set fids = this.andFids(startOfFilterStack);
            resultingFilter = this.buildFilter(filter, startOfFilterStack);
            resultingFilter.fids.addAll(fids);
            if (resultingFilter.filter != Filter.EXCLUDE && !fids.isEmpty()) {
                this.requiresPostProcessing = true;
            }
        } else if (filter instanceof Or) {
            Set fids = this.orFids(startOfFilterStack);
            resultingFilter = this.buildFilter(filter, startOfFilterStack);
            resultingFilter.fids.addAll(fids);
        } else {
            resultingFilter = filter instanceof Not ? this.buildFilter(filter, startOfFilterStack) : this.buildFilter(filter, startOfFilterStack);
        }
        return resultingFilter;
    }

    private Set orFids(int startOfFilterStack) {
        HashSet set = new HashSet();
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            set.addAll(data.fids);
        }
        return set;
    }

    private Set andFids(int startOfFilterStack) {
        if (!this.hasFidFilter(startOfFilterStack)) {
            return Collections.emptySet();
        }
        HashSet<Data> toRemove = new HashSet<Data>();
        ArrayList<Set> fidSet = new ArrayList<Set>();
        boolean doRemove = true;
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) {
                toRemove.add(data);
                continue;
            }
            fidSet.add(data.fids);
            if (data.filter == Filter.EXCLUDE) continue;
            doRemove = false;
        }
        if (doRemove) {
            this.current.removeAll(toRemove);
        }
        if (fidSet.isEmpty()) {
            return Collections.emptySet();
        }
        if (fidSet.size() == 1) {
            return (Set)fidSet.get(0);
        }
        HashSet<String> set = new HashSet<String>();
        for (Set tmp : fidSet) {
            for (Object o : tmp) {
                String fid = (String)o;
                if (!this.allContain(fid, fidSet)) continue;
                set.add(fid);
            }
        }
        return set;
    }

    private boolean allContain(String fid, List fidSets) {
        for (Object fidSet : fidSets) {
            Set tmp = (Set)fidSet;
            if (tmp.contains(fid)) continue;
            return false;
        }
        return true;
    }

    private Data buildFilter(Filter filter, int startOfFilterStack) throws IllegalFilterException {
        if (this.current.isEmpty()) {
            return Data.ALL;
        }
        if (filter instanceof Not) {
            return this.buildNotFilter(startOfFilterStack);
        }
        if (this.current.size() == startOfFilterStack + 1) {
            return this.current.pop();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        while (this.current.size() > startOfFilterStack) {
            Data data = this.current.pop();
            if (data.filter == Filter.EXCLUDE) continue;
            filterList.add(data.filter);
        }
        BinaryLogicOperator f = filter instanceof And ? this.ff.and(filterList) : (filter instanceof Or ? this.ff.or(filterList) : null);
        return new Data(this.compressFilter(filter, f));
    }

    private Filter compressFilter(Filter filter, BinaryLogicOperator f) throws IllegalFilterException {
        BinaryLogicOperator result;
        int added = 0;
        ArrayList<Filter> resultList = new ArrayList<Filter>();
        if (filter instanceof And) {
            if (this.contains(f, Filter.EXCLUDE)) {
                return Filter.EXCLUDE;
            }
            for (Filter child : f.getChildren()) {
                if (child == Filter.INCLUDE) continue;
                ++added;
                resultList.add(child);
            }
            if (resultList.isEmpty()) {
                return Filter.EXCLUDE;
            }
            result = this.ff.and(resultList);
        } else if (filter instanceof Or) {
            if (this.contains(f, Filter.INCLUDE)) {
                return Filter.INCLUDE;
            }
            for (Filter item : f.getChildren()) {
                Filter child = item;
                if (child == Filter.EXCLUDE) continue;
                ++added;
                resultList.add(child);
            }
            if (resultList.isEmpty()) {
                return Filter.EXCLUDE;
            }
            result = this.ff.or(resultList);
        } else {
            return Filter.EXCLUDE;
        }
        switch (added) {
            case 0: {
                return Filter.EXCLUDE;
            }
            case 1: {
                return result.getChildren().iterator().next();
            }
        }
        return result;
    }

    private boolean contains(BinaryLogicOperator f, Filter toFind) {
        for (Filter filter : f.getChildren()) {
            if (!toFind.equals(filter)) continue;
            return true;
        }
        return false;
    }

    private Data buildNotFilter(int startOfFilterStack) {
        if (this.current.size() > startOfFilterStack + 1) {
            throw new UnsupportedFilterException("A not filter cannot have more than one filter");
        }
        Data tmp = this.current.pop();
        Data data = new Data(this.ff.not(tmp.filter));
        if (!tmp.fids.isEmpty()) {
            data.filter = Filter.INCLUDE;
            data.fids.clear();
            this.requiresPostProcessing = true;
        }
        return data;
    }

    private Data createHighLevelLogicFilter(Filter filter, int startOfFilterStack) throws IllegalFilterException {
        if (this.hasFidFilter(startOfFilterStack)) {
            if (filter instanceof And) {
                Set fids = this.andFids(startOfFilterStack);
                Data data = this.buildFilter(filter, startOfFilterStack);
                data.fids.addAll(fids);
                return data;
            }
            if (filter instanceof Or) {
                if (this.hasNonFidFilter(startOfFilterStack)) {
                    throw new UnsupportedFilterException("Maximum compliance does not allow Logic filters to contain FidFilters");
                }
                Set fids = this.orFids(startOfFilterStack);
                this.pop(startOfFilterStack);
                Data data = new Data();
                data.fids.addAll(fids);
                return data;
            }
            if (filter instanceof Not) {
                return this.buildFilter(filter, startOfFilterStack);
            }
            return Data.ALL;
        }
        return this.buildFilter(filter, startOfFilterStack);
    }

    private void pop(int startOfFilterStack) {
        while (this.current.size() > startOfFilterStack) {
            this.current.pop();
        }
    }

    private boolean hasNonFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.filter == Filter.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private boolean hasFidFilter(int startOfFilterStack) {
        for (int i = startOfFilterStack; i < this.current.size(); ++i) {
            Data data = (Data)this.current.get(i);
            if (data.fids.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void visit(PropertyIsNull filter) {
        this.current.push(new Data(filter));
    }

    public void visit(Id filter) {
        Data data = new Data();
        data.fids.addAll(filter.getIDs());
        this.current.push(data);
    }

    public void visit(IncludeFilter filter) {
        this.current.push(new Data(filter));
    }

    public void visit(ExcludeFilter filter) {
        this.current.push(new Data(filter));
    }

    public boolean requiresPostProcessing() {
        return this.requiresPostProcessing;
    }

    protected void visitLogicFilter(Filter filter) {
        this.visit((BinaryLogicOperator)filter);
    }

    protected void visitCompareFilter(Filter filter) {
        if (filter instanceof PropertyIsNull) {
            this.visit((PropertyIsNull)filter);
            return;
        }
        if (filter instanceof PropertyIsLike) {
            this.visit((PropertyIsLike)filter);
        }
        if (filter instanceof BinaryComparisonOperator) {
            this.visit((BinaryComparisonOperator)filter);
        }
        if (filter instanceof Not) {
            this.visit((Not)filter);
        }
    }

    protected void visitGeometryFilter(SpatialOperator filter) {
        if (filter instanceof BinarySpatialOperator) {
            this.visit((BinarySpatialOperator)filter);
        }
    }

    @Override
    public Object visit(And filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Id filter, Object extraData) {
        Data data = new Data();
        data.fids.addAll(filter.getIDs());
        this.current.push(data);
        return extraData;
    }

    @Override
    public Object visitNullFilter(Object extraData) {
        return extraData;
    }

    @Override
    public Object visit(IncludeFilter filter, Object extraData) {
        this.visit(filter);
        return extraData;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object extraData) {
        this.visit(filter);
        return extraData;
    }

    @Override
    public Object visit(Not filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        this.visitLogicFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        this.current.push(new Data(filter));
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        this.visitCompareFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(BBOX filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Beyond filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Contains filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Crosses filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Disjoint filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(DWithin filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Equals filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Intersects filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Overlaps filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Touches filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(Within filter, Object extraData) {
        this.visitGeometryFilter(filter);
        return extraData;
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visitTemporalFilter(after);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visitTemporalFilter(anyInteracts);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visitTemporalFilter(before);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visitTemporalFilter(begins);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visitTemporalFilter(begunBy);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visitTemporalFilter(during);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visitTemporalFilter(endedBy);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visitTemporalFilter(ends);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visitTemporalFilter(meets);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visitTemporalFilter(metBy);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visitTemporalFilter(overlappedBy);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visitTemporalFilter(contains);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visitTemporalFilter(equals);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visitTemporalFilter(contains);
    }

    protected Object visitTemporalFilter(BinaryTemporalOperator filter) {
        throw new UnsupportedOperationException("Temporal filters not supported");
    }

    private static class Data {
        public static final Data NONE = new Data(Filter.EXCLUDE);
        public static final Data ALL = new Data(Filter.INCLUDE);
        final Set fids = new HashSet();
        Filter filter;

        public Data() {
            this(Filter.EXCLUDE);
        }

        public Data(Filter f) {
            this.filter = f;
        }

        public String toString() {
            return this.filter + ":" + this.fids;
        }
    }
}

