/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.Collections;
import org.geotools.measure.Units;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.datum.BursaWolfParameters;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.Transformation;
import si.uom.NonSI;
import si.uom.SI;

public class GeocentricTranslation
extends ProjectiveTransform {
    private static final long serialVersionUID = -168669443433018655L;
    private final ParameterDescriptorGroup descriptor;

    public GeocentricTranslation(BursaWolfParameters parameters) {
        this(parameters, parameters.isTranslation() ? Provider.PARAMETERS : ProviderSevenParam.PARAMETERS);
    }

    GeocentricTranslation(BursaWolfParameters parameters, ParameterDescriptorGroup descriptor) {
        super(parameters.getAffineTransform());
        this.descriptor = descriptor;
    }

    private GeocentricTranslation(Matrix matrix, ParameterDescriptorGroup descriptor) {
        super(matrix);
        this.descriptor = descriptor;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.descriptor;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        boolean isTranslation;
        BursaWolfParameters parameters = new BursaWolfParameters(null);
        parameters.setAffineTransform(this.getMatrix(), Double.POSITIVE_INFINITY);
        if (ProviderFrameRotation.PARAMETERS.equals(this.descriptor)) {
            parameters.ex = -parameters.ex;
            parameters.ey = -parameters.ey;
            parameters.ez = -parameters.ez;
        }
        GeneralParameterValue[] param = new FloatParameter[(isTranslation = Provider.PARAMETERS.equals(this.descriptor)) ? 3 : 7];
        param[0] = new FloatParameter(Provider.DX, parameters.dx);
        param[1] = new FloatParameter(Provider.DY, parameters.dy);
        param[2] = new FloatParameter(Provider.DZ, parameters.dz);
        if (!isTranslation) {
            param[3] = new FloatParameter(ProviderSevenParam.EX, parameters.ex);
            param[4] = new FloatParameter(ProviderSevenParam.EY, parameters.ey);
            param[5] = new FloatParameter(ProviderSevenParam.EZ, parameters.ez);
            param[6] = new FloatParameter(ProviderSevenParam.PPM, parameters.ppm);
        }
        return new ParameterGroup(this.getParameterDescriptors(), param);
    }

    @Override
    GeocentricTranslation createInverse(Matrix matrix) {
        return new GeocentricTranslation(matrix, this.descriptor);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.descriptor.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            GeocentricTranslation that = (GeocentricTranslation)object;
            return Utilities.equals(this.descriptor, that.descriptor);
        }
        return false;
    }

    public static class ProviderFrameRotation
    extends ProviderSevenParam {
        private static final long serialVersionUID = 5513675854809530038L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderFrameRotation.createDescriptorGroup("Coordinate Frame Rotation (geog2D domain)", "9607");

        public ProviderFrameRotation() {
            super(PARAMETERS);
        }

        @Override
        protected void fill(BursaWolfParameters parameters, ParameterValueGroup values) {
            super.fill(parameters, values);
            parameters.ex = -parameters.ex;
            parameters.ey = -parameters.ey;
            parameters.ez = -parameters.ez;
        }
    }

    public static class ProviderSevenParam
    extends Provider {
        private static final long serialVersionUID = -6398226638364450229L;
        private static final double MAX_ROTATION = 648000.0;
        public static final ParameterDescriptor<Double> EX = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ex"), new NamedIdentifier(Citations.EPSG, "X-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor<Double> EY = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ey"), new NamedIdentifier(Citations.EPSG, "Y-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor<Double> EZ = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ez"), new NamedIdentifier(Citations.EPSG, "Z-axis rotation")}, 0.0, -648000.0, 648000.0, NonSI.SECOND_ANGLE);
        public static final ParameterDescriptor<Double> PPM = ProviderSevenParam.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "ppm"), new NamedIdentifier(Citations.EPSG, "Scale difference")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Units.PPM);
        static final ParameterDescriptorGroup PARAMETERS = ProviderSevenParam.createDescriptorGroup("Position Vector transformation (geog2D domain)", "9606");

        static ParameterDescriptorGroup createDescriptorGroup(String name, String code) {
            return ProviderSevenParam.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, name), new NamedIdentifier(Citations.EPSG, code)}, new ParameterDescriptor[]{DX, DY, DZ, EX, EY, EZ, PPM, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, SRC_DIM, TGT_DIM});
        }

        public ProviderSevenParam() {
            super(PARAMETERS);
        }

        ProviderSevenParam(ParameterDescriptorGroup parameters) {
            super(parameters);
        }

        @Override
        protected void fill(BursaWolfParameters parameters, ParameterValueGroup values) {
            super.fill(parameters, values);
            parameters.ppm = ProviderSevenParam.doubleValue(PPM, values);
            parameters.ex = ProviderSevenParam.doubleValue(EX, values);
            parameters.ey = ProviderSevenParam.doubleValue(EY, values);
            parameters.ez = ProviderSevenParam.doubleValue(EZ, values);
        }
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7160250630666911608L;
        static final int DEFAULT_DIMENSION = 2;
        public static final ParameterDescriptor<Integer> SRC_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "src_dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Integer> TGT_DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "tgt_dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_major")}, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "src_semi_minor")}, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_major")}, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = Provider.createOptionalDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "tgt_semi_minor")}, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> DX = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dx"), new NamedIdentifier(Citations.EPSG, "X-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> DY = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dy"), new NamedIdentifier(Citations.EPSG, "Y-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
        public static final ParameterDescriptor<Double> DZ = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "dz"), new NamedIdentifier(Citations.EPSG, "Z-axis translation")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Geocentric translations (geog2D domain)"), new NamedIdentifier(Citations.EPSG, "9603")}, new ParameterDescriptor[]{DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, SRC_DIM, TGT_DIM});

        public Provider() {
            this(PARAMETERS);
        }

        Provider(ParameterDescriptorGroup parameters) {
            super(3, 3, parameters);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            BursaWolfParameters parameters = new BursaWolfParameters(null);
            this.fill(parameters, values);
            return Provider.concatenate(Provider.concatenate(new GeocentricTranslation(parameters, this.getParameters()), values, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, SRC_DIM), values, TGT_SEMI_MAJOR, TGT_SEMI_MINOR, TGT_DIM);
        }

        protected void fill(BursaWolfParameters parameters, ParameterValueGroup values) {
            parameters.dx = Provider.doubleValue(DX, values);
            parameters.dy = Provider.doubleValue(DY, values);
            parameters.dz = Provider.doubleValue(DZ, values);
        }

        private static MathTransform concatenate(MathTransform transform, ParameterValueGroup values, ParameterDescriptor major, ParameterDescriptor minor, ParameterDescriptor dim) {
            double semiMajor = Provider.doubleValue(major, values);
            double semiMinor = Provider.doubleValue(minor, values);
            int dimension = Provider.intValue(dim, values);
            switch (dimension) {
                case 0: {
                    if (Double.isNaN(semiMajor) && Double.isNaN(semiMinor)) {
                        return transform;
                    }
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format(58, dim.getName().getCode(), dimension));
                }
            }
            Provider.ensureValid(major, semiMajor);
            Provider.ensureValid(minor, semiMinor);
            GeocentricTransform step = new GeocentricTransform(semiMajor, semiMinor, SI.METRE, dimension == 3);
            if (dim == SRC_DIM) {
                return ConcatenatedTransform.create(step, transform);
            }
            return ConcatenatedTransform.create(transform, step.inverse());
        }

        private static void ensureValid(ParameterDescriptor param, double value) {
            if (!(value > 0.0)) {
                throw new IllegalStateException(Errors.format(99, param.getName().getCode()));
            }
        }
    }
}

