/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultImageCRS;
import org.geotools.referencing.crs.DefaultProjectedCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.referencing.crs.DefaultVerticalCRS;
import org.geotools.referencing.cs.DefaultAffineCS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultCylindricalCS;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.cs.DefaultLinearCS;
import org.geotools.referencing.cs.DefaultPolarCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.cs.DefaultTimeCS;
import org.geotools.referencing.cs.DefaultUserDefinedCS;
import org.geotools.referencing.cs.DefaultVerticalCS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.datum.DefaultImageDatum;
import org.geotools.referencing.datum.DefaultPrimeMeridian;
import org.geotools.referencing.datum.DefaultTemporalDatum;
import org.geotools.referencing.datum.DefaultVerticalDatum;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.wkt.Parser;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.CanonicalSet;
import org.geotools.util.factory.BufferedFactory;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.Hints;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;

public class ReferencingObjectFactory
extends ReferencingFactory
implements CSFactory,
DatumFactory,
CRSFactory,
BufferedFactory {
    private MathTransformFactory mtFactory;
    private Parser parser;
    private final CanonicalSet<IdentifiedObject> pool = CanonicalSet.newInstance(IdentifiedObject.class);

    public ReferencingObjectFactory() {
        this(null);
    }

    public ReferencingObjectFactory(Hints hints) {
        if (hints != null && !hints.isEmpty()) {
            this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(hints);
            DatumFactory datumFactory = ReferencingFactoryFinder.getDatumFactory(hints);
            this.createParser(datumFactory, this.mtFactory);
            this.addHints(datumFactory);
            this.addHints(this.mtFactory);
        }
    }

    private void addHints(Object factory) {
        if (factory instanceof Factory) {
            this.hints.putAll(((Factory)factory).getImplementationHints());
        }
    }

    private synchronized MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
        }
        return this.mtFactory;
    }

    @Override
    public Ellipsoid createEllipsoid(Map<String, ?> properties, double semiMajorAxis, double semiMinorAxis, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createEllipsoid(properties, semiMajorAxis, semiMinorAxis, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        ellipsoid = this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    @Override
    public Ellipsoid createFlattenedSphere(Map<String, ?> properties, double semiMajorAxis, double inverseFlattening, Unit<Length> unit) throws FactoryException {
        Ellipsoid ellipsoid;
        try {
            ellipsoid = DefaultEllipsoid.createFlattenedSphere(properties, semiMajorAxis, inverseFlattening, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        ellipsoid = this.pool.unique(ellipsoid);
        return ellipsoid;
    }

    @Override
    public PrimeMeridian createPrimeMeridian(Map<String, ?> properties, double longitude, Unit<Angle> angularUnit) throws FactoryException {
        PrimeMeridian meridian;
        try {
            meridian = new DefaultPrimeMeridian(properties, longitude, angularUnit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        meridian = this.pool.unique(meridian);
        return meridian;
    }

    @Override
    public GeodeticDatum createGeodeticDatum(Map<String, ?> properties, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        GeodeticDatum datum;
        try {
            datum = new DefaultGeodeticDatum(properties, ellipsoid, primeMeridian);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = this.pool.unique(datum);
        return datum;
    }

    @Override
    public VerticalDatum createVerticalDatum(Map<String, ?> properties, VerticalDatumType type) throws FactoryException {
        VerticalDatum datum;
        try {
            datum = new DefaultVerticalDatum(properties, type);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = this.pool.unique(datum);
        return datum;
    }

    @Override
    public TemporalDatum createTemporalDatum(Map<String, ?> properties, Date origin) throws FactoryException {
        TemporalDatum datum;
        try {
            datum = new DefaultTemporalDatum(properties, origin);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = this.pool.unique(datum);
        return datum;
    }

    @Override
    public EngineeringDatum createEngineeringDatum(Map<String, ?> properties) throws FactoryException {
        EngineeringDatum datum;
        try {
            datum = new DefaultEngineeringDatum(properties);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = this.pool.unique(datum);
        return datum;
    }

    @Override
    public ImageDatum createImageDatum(Map<String, ?> properties, PixelInCell pixelInCell) throws FactoryException {
        ImageDatum datum;
        try {
            datum = new DefaultImageDatum(properties, pixelInCell);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        datum = this.pool.unique(datum);
        return datum;
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(Map<String, ?> properties, String abbreviation, AxisDirection direction, Unit<?> unit) throws FactoryException {
        CoordinateSystemAxis axis;
        try {
            axis = new DefaultCoordinateSystemAxis(properties, abbreviation, direction, unit);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        axis = this.pool.unique(axis);
        return axis;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        CartesianCS cs;
        try {
            cs = new DefaultCartesianCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public CartesianCS createCartesianCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        CartesianCS cs;
        try {
            cs = new DefaultCartesianCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        AffineCS cs;
        try {
            cs = new DefaultAffineCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public AffineCS createAffineCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        AffineCS cs;
        try {
            cs = new DefaultAffineCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public PolarCS createPolarCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        PolarCS cs;
        try {
            cs = new DefaultPolarCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public CylindricalCS createCylindricalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        CylindricalCS cs;
        try {
            cs = new DefaultCylindricalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public SphericalCS createSphericalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        SphericalCS cs;
        try {
            cs = new DefaultSphericalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        EllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        EllipsoidalCS cs;
        try {
            cs = new DefaultEllipsoidalCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public VerticalCS createVerticalCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        VerticalCS cs;
        try {
            cs = new DefaultVerticalCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public TimeCS createTimeCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        TimeCS cs;
        try {
            cs = new DefaultTimeCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public LinearCS createLinearCS(Map<String, ?> properties, CoordinateSystemAxis axis) throws FactoryException {
        LinearCS cs;
        try {
            cs = new DefaultLinearCS(properties, axis);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1) throws FactoryException {
        UserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(properties, axis0, axis1);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public UserDefinedCS createUserDefinedCS(Map<String, ?> properties, CoordinateSystemAxis axis0, CoordinateSystemAxis axis1, CoordinateSystemAxis axis2) throws FactoryException {
        UserDefinedCS cs;
        try {
            cs = new DefaultUserDefinedCS(properties, axis0, axis1, axis2);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        cs = this.pool.unique(cs);
        return cs;
    }

    @Override
    public CompoundCRS createCompoundCRS(Map<String, ?> properties, CoordinateReferenceSystem[] elements) throws FactoryException {
        CompoundCRS crs;
        try {
            crs = new DefaultCompoundCRS(properties, elements);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public EngineeringCRS createEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, CoordinateSystem cs) throws FactoryException {
        EngineeringCRS crs;
        try {
            crs = new DefaultEngineeringCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public ImageCRS createImageCRS(Map<String, ?> properties, ImageDatum datum, AffineCS cs) throws FactoryException {
        ImageCRS crs;
        try {
            crs = new DefaultImageCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public TemporalCRS createTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) throws FactoryException {
        TemporalCRS crs;
        try {
            crs = new DefaultTemporalCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public VerticalCRS createVerticalCRS(Map<String, ?> properties, VerticalDatum datum, VerticalCS cs) throws FactoryException {
        VerticalCRS crs;
        try {
            crs = new DefaultVerticalCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, CartesianCS cs) throws FactoryException {
        GeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public GeocentricCRS createGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, SphericalCS cs) throws FactoryException {
        GeocentricCRS crs;
        try {
            crs = new DefaultGeocentricCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public GeographicCRS createGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, EllipsoidalCS cs) throws FactoryException {
        GeographicCRS crs;
        try {
            crs = new DefaultGeographicCRS(properties, datum, cs);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> properties, CoordinateReferenceSystem baseCRS, Conversion conversionFromBase, CoordinateSystem derivedCS) throws FactoryException {
        DerivedCRS crs;
        MathTransform mt = conversionFromBase.getMathTransform();
        if (mt == null) {
            ParameterValueGroup parameters = conversionFromBase.getParameterValues();
            MathTransformFactory mtFactory = this.getMathTransformFactory();
            mt = mtFactory.createParameterizedTransform(parameters);
        }
        try {
            crs = new DefaultDerivedCRS(properties, conversionFromBase, baseCRS, mt, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    public ProjectedCRS createProjectedCRS(Map<String, Object> properties, OperationMethod method, GeographicCRS base, MathTransform baseToDerived, CartesianCS derivedCS) throws FactoryException {
        ProjectedCRS crs;
        try {
            crs = new DefaultProjectedCRS(properties, method, base, baseToDerived, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public ProjectedCRS createProjectedCRS(Map<String, ?> properties, GeographicCRS baseCRS, Conversion conversionFromBase, CartesianCS derivedCS) throws FactoryException {
        ProjectedCRS crs;
        MathTransform mt;
        MathTransform existing = conversionFromBase.getMathTransform();
        MathTransformFactory mtFactory = this.getMathTransformFactory();
        if (existing != null && mtFactory instanceof DefaultMathTransformFactory) {
            mt = ((DefaultMathTransformFactory)mtFactory).createBaseToDerived((CoordinateReferenceSystem)baseCRS, existing, (CoordinateSystem)derivedCS);
        } else {
            ParameterValueGroup parameters = conversionFromBase.getParameterValues();
            mt = mtFactory.createBaseToDerived(baseCRS, parameters, derivedCS);
            OperationMethod method = conversionFromBase.getMethod();
            if (!(method instanceof MathTransformProvider) && !properties.containsKey("conversionType") && (method = mtFactory.getLastMethodUsed()) instanceof MathTransformProvider) {
                HashMap copy = new HashMap(properties);
                copy.put("conversionType", ((MathTransformProvider)method).getOperationType());
                properties = copy;
            }
            if (existing != null && existing.equals(mt)) {
                mt = existing;
            }
        }
        try {
            crs = new DefaultProjectedCRS(properties, conversionFromBase, baseCRS, mt, derivedCS);
        }
        catch (IllegalArgumentException exception) {
            throw new FactoryException(exception);
        }
        crs = this.pool.unique(crs);
        return crs;
    }

    @Override
    public CoordinateReferenceSystem createFromXML(String xml) throws FactoryException {
        throw new FactoryException("Not yet implemented");
    }

    @Override
    public synchronized CoordinateReferenceSystem createFromWKT(String wkt) throws FactoryException {
        if (this.parser == null) {
            this.createParser(ReferencingFactoryFinder.getDatumFactory(null), this.getMathTransformFactory());
        }
        try {
            return this.parser.parseCoordinateReferenceSystem(wkt);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception);
        }
    }

    private void createParser(DatumFactory datumFactory, MathTransformFactory mtFactory) {
        this.parser = new Parser(Symbols.DEFAULT, datumFactory, this, this, mtFactory);
    }
}

