/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.ManyAuthoritiesFactory;
import org.geotools.referencing.factory.ThreadedAuthorityFactory;
import org.geotools.util.UnmodifiableArrayList;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class DefaultAuthorityFactory
extends ThreadedAuthorityFactory
implements CRSAuthorityFactory {
    private static List<String> AUTHORITY_LESS = UnmodifiableArrayList.wrap("WGS84(DD)");
    private static Logger LOGGER = Logging.getLogger(DefaultAuthorityFactory.class);

    DefaultAuthorityFactory(boolean longitudeFirst) {
        super(DefaultAuthorityFactory.getBackingFactory(longitudeFirst));
    }

    private static AbstractAuthorityFactory getBackingFactory(boolean longitudeFirst) {
        Hints hints = GeoTools.getDefaultHints();
        if (longitudeFirst) {
            hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.TRUE);
        }
        ArrayList<CRSAuthorityFactory> factories = new ArrayList<CRSAuthorityFactory>(ReferencingFactoryFinder.getCRSAuthorityFactories(hints));
        if (Boolean.TRUE.equals(hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE))) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Factories with FORCE_LONGITUDE_FIRST_AXIS_ORDER=true :\n" + DefaultAuthorityFactory.logClassNames(factories));
            }
            factories.addAll(ReferencingFactoryFinder.getCRSAuthorityFactories(hints));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Factories used as backingFactory :\n" + DefaultAuthorityFactory.logClassNames(factories));
        }
        return new ManyAuthoritiesFactory(factories);
    }

    private static String logClassNames(Collection<CRSAuthorityFactory> factories) {
        return String.join((CharSequence)"\n", (CharSequence[])factories.stream().map(factory -> "  " + factory.getClass().getName()).toArray(String[]::new));
    }

    static Set<String> getSupportedCodes(String authority) {
        LinkedHashSet<String> result = new LinkedHashSet<String>(AUTHORITY_LESS);
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            Set<String> codes;
            if (!Citations.identifierMatches(factory.getAuthority(), authority)) continue;
            try {
                codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
            }
            catch (Exception exception) {
                CRS.unexpectedException("getSupportedCodes", exception);
                continue;
            }
            if (codes == null) continue;
            result.addAll(codes);
        }
        return result;
    }

    static Set<String> getSupportedAuthorities(boolean returnAliases) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        block0: for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            for (Identifier identifier : factory.getAuthority().getIdentifiers()) {
                result.add(identifier.getCode());
                if (returnAliases) continue;
                continue block0;
            }
        }
        return result;
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        if (code != null) {
            code = code.trim();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Create CRS with code:" + code);
            }
            if (code.equalsIgnoreCase("WGS84(DD)")) {
                return DefaultGeographicCRS.WGS84;
            }
        }
        assert (!AUTHORITY_LESS.contains(code)) : code;
        return super.createCoordinateReferenceSystem(code);
    }
}

