/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.measure.PrefixDefinition;
import org.geotools.measure.SimpleUnitFormatForwarder;
import org.geotools.measure.UnitDefinition;

public class BaseUnitFormatter
extends SimpleUnitFormatForwarder.DefaultFormatForwarder {
    public BaseUnitFormatter(UnitDefinition ... unitDefinitions) {
        this(Arrays.asList(unitDefinitions));
    }

    public BaseUnitFormatter(List<UnitDefinition> unitDefinitions) {
        for (UnitDefinition unitDefinition : unitDefinitions) {
            Unit<?> unit = unitDefinition.getUnit();
            String unitSymbol = unitDefinition.getSymbolOverride() != null ? unitDefinition.getSymbolOverride() : unit.getSymbol();
            this.label(unit, unitSymbol);
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                this.addUnit(unit, unitSymbol, prefix);
            }
            for (String alias : unitDefinition.getAliases()) {
                this.alias((Unit)unit, alias);
            }
            for (PrefixDefinition prefix : unitDefinition.getPrefixes()) {
                for (String alias : unitDefinition.getAliases()) {
                    this.addAlias(unit, alias, prefix);
                }
            }
        }
    }

    public Map<Unit<?>, String> getUnitToSymbolMap() {
        return Collections.unmodifiableMap(this.unitToName);
    }

    public Map<String, Unit<?>> getSymbolToUnitMap() {
        return Collections.unmodifiableMap(this.nameToUnit);
    }

    @Override
    public void label(Unit<?> unit, String label) {
        super.label(unit, label);
        this.addUnit(unit);
    }

    protected void addUnit(Unit<?> unit) {
    }

    private void addUnit(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.label(prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.label(prefixedUnit, prefixAlias + unitSymbol);
        }
    }

    private void addAlias(Unit<?> unit, String unitSymbol, PrefixDefinition prefix) {
        Unit<?> prefixedUnit = unit.prefix(prefix.getPrefix());
        String prefixString = prefix.getPrefix().getSymbol();
        String prefixedSymbol = prefixString + unitSymbol;
        this.alias((Unit)prefixedUnit, prefixedSymbol);
        for (String prefixAlias : prefix.getPrefixAliases()) {
            this.alias((Unit)prefixedUnit, prefixAlias + unitSymbol);
        }
    }
}

