/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPProxy;
import org.geotools.http.HTTPResponse;
import org.geotools.util.Base64;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class SimpleHttpClient
implements HTTPClient,
HTTPProxy {
    private static final Logger LOGGER = Logging.getLogger(SimpleHttpClient.class);
    private static final int DEFAULT_TIMEOUT = 30;
    private String user;
    private String password;
    private int connectTimeout = 30;
    private int readTimeout = 30;
    private boolean tryGzip = true;

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        return this.get(url, null);
    }

    @Override
    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        URLConnection connection;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL is " + url);
        }
        if ((connection = this.openConnection(url)) instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("GET");
        }
        connection.addRequestProperty("User-Agent", "GeoTools HTTPClient (" + GeoTools.getVersion() + ")");
        if (headers != null) {
            for (Map.Entry<String, String> headerNameValue : headers.entrySet()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Adding header " + headerNameValue.getKey() + " = " + headerNameValue.getValue());
                }
                connection.addRequestProperty(headerNameValue.getKey(), headerNameValue.getValue());
            }
        }
        connection.connect();
        return new SimpleHTTPResponse(connection);
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        URLConnection connection = this.openConnection(url);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("POST");
        }
        connection.setDoOutput(true);
        if (postContentType != null) {
            connection.setRequestProperty("Content-type", postContentType);
        }
        connection.connect();
        try (OutputStream outputStream = connection.getOutputStream();){
            int count;
            byte[] buff = new byte[512];
            while ((count = postContent.read(buff)) > -1) {
                outputStream.write(buff, 0, count);
            }
            outputStream.flush();
        }
        return new SimpleHTTPResponse(connection);
    }

    private URLConnection openConnection(URL finalURL) throws IOException {
        URLConnection connection = finalURL.openConnection();
        boolean http = connection instanceof HttpURLConnection;
        if (http && this.tryGzip) {
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (http && this.getConnectTimeout() > 0) {
            connection.setConnectTimeout(1000 * this.getConnectTimeout());
        }
        if (http && this.getReadTimeout() > 0) {
            connection.setReadTimeout(1000 * this.getReadTimeout());
        }
        String username = this.getUser();
        String password = this.getPassword();
        if (http && username != null && password != null) {
            String userpassword = username + ":" + password;
            String encodedAuthorization = Base64.encodeBytes(userpassword.getBytes(StandardCharsets.UTF_8), 8);
            connection.setRequestProperty("Authorization", "Basic " + encodedAuthorization);
        }
        return connection;
    }

    @Override
    public void setTryGzip(boolean tryGZIP) {
        this.tryGzip = tryGZIP;
    }

    @Override
    public boolean isTryGzip() {
        return this.tryGzip;
    }

    public static class SimpleHTTPResponse
    implements HTTPResponse {
        private URLConnection connection;
        private InputStream responseStream;

        public SimpleHTTPResponse(URLConnection connection) throws IOException {
            this.connection = connection;
            InputStream inputStream = null;
            try {
                inputStream = connection.getInputStream();
                String contentEncoding = connection.getContentEncoding();
                if (contentEncoding != null && connection.getContentEncoding().indexOf("gzip") != -1) {
                    inputStream = new GZIPInputStream(inputStream);
                }
            }
            catch (Exception e) {
                if (inputStream != null) {
                    inputStream.close();
                }
                throw e;
            }
            this.responseStream = inputStream;
        }

        @Override
        public void dispose() {
            if (this.responseStream != null) {
                try {
                    this.responseStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.responseStream = null;
            }
            if (this.connection != null) {
                if (this.connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.connection).disconnect();
                }
                this.connection = null;
            }
        }

        @Override
        public String getContentType() {
            return this.connection.getContentType();
        }

        @Override
        public String getResponseHeader(String headerName) {
            return this.connection.getHeaderField(headerName);
        }

        @Override
        public InputStream getResponseStream() throws IOException {
            return this.responseStream;
        }

        @Override
        public String getResponseCharset() {
            String contentType = this.getContentType();
            if (null == contentType) {
                return null;
            }
            String[] split = contentType.split(";");
            for (int i = 1; i < split.length; ++i) {
                String[] mimeParam = split[i].split("=");
                if (mimeParam.length != 2 || !"charset".equalsIgnoreCase(mimeParam[0])) continue;
                String charset = mimeParam[1];
                return charset.trim();
            }
            return null;
        }
    }
}

