/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.feature.type.Types;
import org.geotools.gml3.GML;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.GMLSchema;
import org.geotools.gml3.smil.SMIL20LANGSchema;
import org.geotools.gml3.smil.SMIL20Schema;
import org.geotools.gml3.v3_2.gco.GCOSchema;
import org.geotools.gml3.v3_2.gmd.GMDSchema;
import org.geotools.gml3.v3_2.gmx.GMXSchema;
import org.geotools.gml3.v3_2.gsr.GSRSchema;
import org.geotools.gml3.v3_2.gss.GSSSchema;
import org.geotools.gml3.v3_2.gts.GTSSchema;
import org.geotools.xs.XS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.complex.FeatureTypeRegistryConfiguration;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;

public class GmlFeatureTypeRegistryConfiguration
implements FeatureTypeRegistryConfiguration {
    String namespace;
    private static final Map<QName, Class<? extends Configuration>> SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP = new LinkedHashMap<QName, Class<? extends Configuration>>(){
        {
            this.put(GML.AbstractFeatureType, GMLConfiguration.class);
            this.put(org.geotools.gml3.v3_2.GML.AbstractFeatureType, org.geotools.gml3.v3_2.GMLConfiguration.class);
        }
    };

    public GmlFeatureTypeRegistryConfiguration(String uri) {
        this.namespace = uri != null ? uri : "";
    }

    @Override
    public Collection<Schema> getSchemas() {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(new SMIL20Schema());
        schemas.add(new SMIL20LANGSchema());
        schemas.add(new GMLSchema());
        schemas.add(new org.geotools.gml3.v3_2.GMLSchema());
        schemas.add(new GCOSchema());
        schemas.add(new GMDSchema());
        schemas.add(new GMXSchema());
        schemas.add(new GSRSchema());
        schemas.add(new GSSSchema());
        schemas.add(new GTSSchema());
        return schemas;
    }

    @Override
    public Collection<Configuration> getConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.add(new GMLConfiguration());
        configurations.add(new org.geotools.gml3.v3_2.GMLConfiguration());
        return configurations;
    }

    public QName getAbstractFeatureType() {
        if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
            return org.geotools.gml3.v3_2.GML.AbstractFeatureType;
        }
        return GML.AbstractFeatureType;
    }

    public QName getAbstractGeometryType() {
        if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
            return org.geotools.gml3.v3_2.GML.AbstractGeometryType;
        }
        return GML.AbstractGeometryType;
    }

    public String getNameSpace() {
        if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
            return "http://www.opengis.net/gml/3.2";
        }
        return "http://www.opengis.net/gml";
    }

    public QName getId() {
        if (this.namespace.equals("http://www.opengis.net/gml/3.2")) {
            return org.geotools.gml3.v3_2.GML.id;
        }
        return GML.id;
    }

    public void setEmptyNamespace(XSDTypeDefinition typeDefinition) {
        if (this.namespace.isEmpty()) {
            if (GmlFeatureTypeRegistryConfiguration.isBasedOn(typeDefinition, "http://www.opengis.net/gml/3.2")) {
                this.namespace = "http://www.opengis.net/gml/3.2";
            } else if (GmlFeatureTypeRegistryConfiguration.isBasedOn(typeDefinition, "http://www.opengis.net/gml")) {
                this.namespace = "http://www.opengis.net/gml";
            }
        }
    }

    @Override
    public boolean isFeatureType(XSDTypeDefinition typeDefinition) {
        this.setEmptyNamespace(typeDefinition);
        return GmlFeatureTypeRegistryConfiguration.isDerivedFrom(typeDefinition, this.getAbstractFeatureType());
    }

    @Override
    public boolean isGeometryType(XSDTypeDefinition typeDefinition) {
        this.setEmptyNamespace(typeDefinition);
        return GmlFeatureTypeRegistryConfiguration.isDerivedFrom(typeDefinition, this.getAbstractGeometryType());
    }

    @Override
    public boolean isIdentifiable(XSDComplexTypeDefinition typeDefinition) {
        EList<XSDAttributeUse> attributeUses = typeDefinition.getAttributeUses();
        String idAttName = this.getId().getLocalPart();
        for (Object attributeUs : attributeUses) {
            XSDAttributeUse use = (XSDAttributeUse)attributeUs;
            XSDAttributeUseCategory useCategory = use.getUse();
            XSDAttributeDeclaration idAtt = use.getAttributeDeclaration();
            String targetNamespace = idAtt.getTargetNamespace();
            String name = idAtt.getName();
            if (!this.getNameSpace().equals(targetNamespace) || !idAttName.equals(name) || !XSDAttributeUseCategory.REQUIRED_LITERAL.equals((Object)useCategory)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBasedOn(XSDTypeDefinition typeDefinition, String superNS) {
        XSDTypeDefinition baseType;
        while ((baseType = typeDefinition.getBaseType()) != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && XS.ANYTYPE.getLocalPart().equals(name)) {
                return false;
            }
            if (superNS.equals(targetNamespace)) {
                return true;
            }
            typeDefinition = baseType;
        }
        return false;
    }

    private static boolean isDerivedFrom(XSDTypeDefinition typeDefinition, QName baseTypeName) {
        return GmlFeatureTypeRegistryConfiguration.isDerivedFrom(typeDefinition, Types.toTypeName(baseTypeName));
    }

    private static boolean isDerivedFrom(XSDTypeDefinition typeDefinition, Name superTypeName) {
        XSDTypeDefinition baseType;
        String superNS = superTypeName.getNamespaceURI();
        String superName = superTypeName.getLocalPart();
        while ((baseType = typeDefinition.getBaseType()) != null) {
            String targetNamespace = baseType.getTargetNamespace();
            String name = baseType.getName();
            if ("http://www.w3.org/2001/XMLSchema".equals(targetNamespace) && XS.ANYTYPE.getLocalPart().equals(name)) {
                return false;
            }
            if (superNS.equals(targetNamespace) && superName.equals(name)) {
                return true;
            }
            typeDefinition = baseType;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration findGmlConfiguration(Configuration configuration) {
        block9: {
            SchemaIndex index = null;
            index = Schemas.findSchemas(configuration);
            for (QName name : SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP.keySet()) {
                XSDTypeDefinition type = index.getTypeDefinition(name);
                if (type == null) continue;
                try {
                    Configuration configuration2 = SUPPORTED_GML_KNOWN_TYPE_TO_CONFIGURATION_MAP.get(name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    return configuration2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            for (XSDSchema schema : index.getSchemas()) {
                String ns = schema.getTargetNamespace();
                if (ns == null || !ns.startsWith("http://www.opengis.net/gml")) continue;
                throw new RuntimeException("Unsupported GML version for schema at " + configuration.getXSD().getSchemaLocation());
            }
            break block9;
            finally {
                if (index != null) {
                    index.destroy();
                }
            }
        }
        return null;
    }
}

