/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.bindings;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.gml2.SrsSyntax;
import org.geotools.gml2.bindings.GMLEncodingUtils;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GML2EncodingUtils {
    static Logger LOGGER = Logging.getLogger(GML2EncodingUtils.class);
    static GMLEncodingUtils e = new GMLEncodingUtils(GML.getInstance());

    public static String epsgCode(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        for (ReferenceIdentifier referenceIdentifier : crs.getIdentifiers()) {
            ReferenceIdentifier id = referenceIdentifier;
            if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
            return id.getCode();
        }
        return null;
    }

    public static String toURI(CoordinateReferenceSystem crs) {
        return GML2EncodingUtils.toURI(crs, false);
    }

    public static String toURI(CoordinateReferenceSystem crs, boolean forceOldStyle) {
        return GML2EncodingUtils.toURI(crs, forceOldStyle ? SrsSyntax.OGC_HTTP_URL : SrsSyntax.OGC_URN_EXPERIMENTAL);
    }

    public static String toURI(CoordinateReferenceSystem crs, SrsSyntax srsSyntax) {
        String code = GML2EncodingUtils.epsgCode(crs);
        CRS.AxisOrder axisOrder = CRS.getAxisOrder(crs, true);
        if (code != null) {
            if (axisOrder == CRS.AxisOrder.EAST_NORTH || axisOrder == CRS.AxisOrder.INAPPLICABLE) {
                srsSyntax = SrsSyntax.OGC_HTTP_URL;
            }
            return srsSyntax.getPrefix() + code;
        }
        if (crs != null && crs.getName() != null && crs.getName().getCode() != null) {
            try {
                new URI(crs.getName().getCode());
                return crs.getName().getCode();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Deprecated
    public static CoordinateReferenceSystem getCRS(Geometry g) {
        return JTS.getCRS(g);
    }

    public static String getID(Geometry g) {
        return e.getMetadata(g, "gml:id");
    }

    public static void setID(Geometry g, String id) {
        e.setMetadata(g, "gml:id", id);
    }

    public static String getName(Geometry g) {
        return e.getMetadata(g, "gml:name");
    }

    public static void setName(Geometry g, String name) {
        e.setMetadata(g, "gml:name", name);
    }

    public static String getDescription(Geometry g) {
        return e.getMetadata(g, "gml:description");
    }

    public static void setDescription(Geometry g, String description) {
        e.setMetadata(g, "gml:description", description);
    }

    public static Element AbstractFeatureType_encode(Object object, Document document, Element value) {
        Feature feature = (Feature)object;
        FeatureType featureType = feature.getType();
        String namespace = featureType.getName().getNamespaceURI();
        String typeName = featureType.getName().getLocalPart();
        Element encoding = document.createElementNS(namespace, typeName);
        encoding.setAttributeNS(null, "fid", feature.getIdentifier().getID());
        return encoding;
    }

    public static List<Object[]> AbstractFeatureType_getProperties(Object object, XSDElementDeclaration element, SchemaIndex schemaIndex, Set<String> toFilter, Configuration configuration) {
        return e.AbstractFeatureType_getProperties(object, element, schemaIndex, toFilter, configuration);
    }

    public static XSDTypeDefinition createXmlTypeFromFeatureType(SimpleFeatureType featureType, SchemaIndex schemaIndex, Set<String> toFilter) {
        return e.createXmlTypeFromFeatureType(featureType, schemaIndex, toFilter);
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name) {
        return e.GeometryPropertyType_getProperty(geometry, name);
    }

    public static Object GeometryPropertyType_getProperty(Geometry geometry, QName name, boolean includeAbstractGeometry) {
        return e.GeometryPropertyType_getProperty(geometry, name, includeAbstractGeometry);
    }

    public static List<Object[]> GeometryPropertyType_getProperties(Geometry geometry) {
        return e.GeometryPropertyType_getProperties(geometry);
    }

    public static Integer getGeometryDimension(Geometry geometry, Configuration config) {
        if (GMLEncodingUtils.isEmpty(geometry)) {
            return null;
        }
        if (config.hasProperty(GMLConfiguration.NO_SRS_DIMENSION)) {
            return null;
        }
        return CoordinateSequences.coordinateDimension(geometry);
    }

    public static Integer getEnvelopeDimension(ReferencedEnvelope e, Configuration configuration) {
        if (e == null || e.isNull() || e.getCoordinateReferenceSystem() == null) {
            return null;
        }
        if (configuration.hasProperty(GMLConfiguration.NO_SRS_DIMENSION)) {
            return null;
        }
        return e.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
    }
}

