/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageioimpl.plugins.cog.TileRange;
import java.util.Map;
import java.util.TreeMap;

public class CogTileInfo {
    protected int headerLength;
    protected Map<Integer, TileRange> tileRanges = new TreeMap<Integer, TileRange>();
    public static final int HEADER_TILE_INDEX = -100;

    public CogTileInfo(int headerLength) {
        this.headerLength = headerLength;
        this.addHeaderRange();
    }

    public TileRange addHeaderRange() {
        return this.tileRanges.put(-100, new TileRange(-100, 0L, this.headerLength));
    }

    public TileRange addTileRange(int tileIndex, long offset, long byteLength) {
        this.checkHeaderSize(offset);
        return this.tileRanges.put(tileIndex, new TileRange(tileIndex, offset, byteLength));
    }

    protected void checkHeaderSize(long offset) {
        if (offset < (long)this.headerLength && offset > 0L) {
            this.headerLength = (int)offset;
            this.tileRanges.put(-100, new TileRange(-100, 0L, this.headerLength));
        }
    }

    public void setHeaderLength(int headerLength) {
        this.headerLength = headerLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public Map<Integer, TileRange> getTileRanges() {
        return this.tileRanges;
    }

    public TileRange getTileRange(int tileIndex) {
        return this.tileRanges.get(tileIndex);
    }

    public TileRange getTileRange(long offset) {
        for (TileRange tileRange : this.tileRanges.values()) {
            if (offset < tileRange.getStart() || offset >= tileRange.getEnd()) continue;
            return tileRange;
        }
        return null;
    }

    public int getTileIndex(long offset) {
        for (Map.Entry<Integer, TileRange> entry : this.tileRanges.entrySet()) {
            if (offset < entry.getValue().getStart() || offset >= entry.getValue().getEnd()) continue;
            return entry.getKey();
        }
        return -1;
    }
}

