/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.cog;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.plugins.cog.CogImageReadParam;
import it.geosolutions.imageioimpl.plugins.cog.CacheManagement;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStream;
import it.geosolutions.imageioimpl.plugins.cog.CogTileInfo;
import it.geosolutions.imageioimpl.plugins.cog.ContiguousRangeComposer;
import it.geosolutions.imageioimpl.plugins.cog.RangeReader;
import it.geosolutions.imageioimpl.plugins.cog.TileCacheEntryKey;
import it.geosolutions.imageioimpl.plugins.cog.TileRange;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStreamImpl;

public class CachingCogImageInputStream
extends ImageInputStreamImpl
implements CogImageInputStream {
    private boolean initialized = false;
    protected URI uri;
    protected RangeReader rangeReader;
    protected CogTileInfo header;
    private static final Logger LOGGER = Logger.getLogger(CachingCogImageInputStream.class.getName());

    public CachingCogImageInputStream(URI uri) {
        this.uri = uri;
    }

    public CachingCogImageInputStream(String uri) {
        this(URI.create(uri));
    }

    public CachingCogImageInputStream(URL url) {
        this(url.toString());
    }

    public CachingCogImageInputStream(BasicAuthURI cogUri) {
        this.uri = cogUri.getUri();
    }

    public CachingCogImageInputStream(URI uri, RangeReader rangeReader) {
        this.uri = uri;
        this.init(rangeReader);
    }

    @Override
    public void init(RangeReader rangeReader) {
        this.rangeReader = rangeReader;
        this.initializeHeader();
    }

    @Override
    public void init(CogImageReadParam param) {
        Class<? extends RangeReader> rangeReaderClass = param.getRangeReaderClass();
        if (null != rangeReaderClass) {
            try {
                this.rangeReader = rangeReaderClass.getDeclaredConstructor(URI.class, Integer.TYPE).newInstance(this.uri, param.getHeaderLength());
            }
            catch (Exception e) {
                LOGGER.severe("Unable to instantiate range reader class " + rangeReaderClass.getCanonicalName());
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Range reader class not specified in CogImageReadParam.");
        }
        if (this.rangeReader == null) {
            throw new RuntimeException("Unable to instantiate range reader class " + rangeReaderClass.getCanonicalName());
        }
        this.initializeHeader(param.getHeaderLength());
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    protected void initializeHeader() {
        this.initializeHeader(CogImageReadParam.DEFAULT_HEADER_LENGTH);
    }

    protected void initializeHeader(int headerLength) {
        this.header = new CogTileInfo(headerLength);
        if (CacheManagement.DEFAULT.headerExists(this.uri.toString())) {
            headerLength = CacheManagement.DEFAULT.getHeader(this.uri.toString()).length;
            this.rangeReader.setHeaderLength(headerLength);
        } else {
            CacheManagement.DEFAULT.cacheHeader(this.uri.toString(), this.rangeReader.fetchHeader());
        }
        this.initialized = true;
    }

    @Override
    public CogTileInfo getHeader() {
        return this.header;
    }

    @Override
    public void readRanges(CogTileInfo cogTileInfo) {
        ContiguousRangeComposer contiguousRangeComposer = new ContiguousRangeComposer(0L, cogTileInfo.getHeaderLength() - 1);
        cogTileInfo.getTileRanges().forEach((tileIndex, tileRange) -> {
            if (tileIndex == -100) {
                return;
            }
            TileCacheEntryKey key = new TileCacheEntryKey(this.uri.toString(), (int)tileIndex);
            if (!CacheManagement.DEFAULT.keyExists(key)) {
                contiguousRangeComposer.addTileRange(tileRange.getStart(), tileRange.getEnd());
            }
        });
        this.rangeReader.setHeaderLength(cogTileInfo.getHeaderLength());
        Set<long[]> ranges = contiguousRangeComposer.getRanges();
        if (ranges.size() == 0) {
            return;
        }
        LOGGER.fine("Submitting " + ranges.size() + " range request(s)");
        Map<Long, byte[]> data = this.rangeReader.read(ranges);
        cogTileInfo.getTileRanges().forEach((tileIndex, tileRange) -> {
            if (tileIndex == -100) {
                return;
            }
            TileCacheEntryKey key = new TileCacheEntryKey(this.uri.toString(), (int)tileIndex);
            for (Map.Entry entry : data.entrySet()) {
                long contiguousRangeOffset = (Long)entry.getKey();
                int contiguousRangeLength = (int)contiguousRangeOffset + ((byte[])entry.getValue()).length;
                if (tileRange.getStart() < contiguousRangeOffset || tileRange.getEnd() >= (long)contiguousRangeLength) continue;
                byte[] contiguousBytes = (byte[])entry.getValue();
                long relativeOffset = tileRange.getStart() - contiguousRangeOffset;
                byte[] tileBytes = Arrays.copyOfRange(contiguousBytes, (int)relativeOffset, (int)tileRange.getEnd());
                CacheManagement.DEFAULT.cacheTile(key, tileBytes);
            }
        });
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b, 0, 1);
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) {
        byte[] bytes;
        TileRange tileRange = this.header.getTileRange(this.streamPos);
        switch (tileRange.getIndex()) {
            case -100: {
                bytes = CacheManagement.DEFAULT.getHeader(this.uri.toString());
                break;
            }
            default: {
                TileCacheEntryKey key = new TileCacheEntryKey(this.uri.toString(), tileRange.getIndex());
                bytes = CacheManagement.DEFAULT.getTile(key);
            }
        }
        int relativeStreamPos = (int)(this.streamPos - tileRange.getStart());
        System.arraycopy(bytes, relativeStreamPos, b, off, len);
        this.streamPos += (long)len;
        return len;
    }
}

