/*
 * Decompiled with CFR 0.152.
 */
package org.pescuma.mergeservices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.pescuma.mergeservices.WebFragment;

public final class MergeServicesTask
extends Task {
    private File dest;
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final List<Exclude> excludes = new ArrayList<Exclude>();
    private WebFragment webFragment = null;
    private static final String WEB_FRAGMENT = "META-INF/web-fragment.xml";

    public synchronized Exclude createExclude() {
        Exclude e = new Exclude();
        this.excludes.add(e);
        return e;
    }

    public void setDest(File dst) {
        this.dest = dst;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    private String readServiceFile(ZipEntry entry, InputStream s) throws IOException {
        int cnt;
        int len = (int)entry.getSize();
        byte[] dat = new byte[len];
        int pos = 0;
        while (0 < (cnt = s.read(dat, pos, len - pos))) {
            pos += cnt;
        }
        if (pos != len) {
            throw new IOException("readFile got:" + pos + " len:" + len);
        }
        String str = new String(dat);
        return str.endsWith("\n") ? str : str + "\n";
    }

    private static void addToZipFile(String source, ZipEntry entry, ZipOutputStream zos, InputStream fis) throws FileNotFoundException, IOException {
        int size = 0;
        try {
            int length;
            zos.putNextEntry(entry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) > 0) {
                zos.write(bytes, 0, length);
                size += length;
            }
            zos.flush();
            zos.closeEntry();
        }
        catch (Exception t) {
            throw new BuildException("addToZipFile(" + source + " , " + entry.getName() + " " + size + "/" + entry.getSize() + ")=>" + t.getMessage());
        }
    }

    private void addEntryContent(ZipOutputStream zos, ZipEntry entry, InputStream in, Map<String, String> services, Map<String, List<String>> once, String source) throws IOException {
        for (Exclude e : this.excludes) {
            if (e.name == null || !SelectorUtils.match((String)e.name, (String)entry.getName())) continue;
            return;
        }
        if (entry.getName().startsWith("META-INF/services/")) {
            String neu = this.readServiceFile(entry, in);
            String old = services.get(entry.getName());
            if (old == null) {
                services.put(entry.getName(), neu);
            } else {
                services.put(entry.getName(), old + neu);
            }
            return;
        }
        if (entry.getName().equals(WEB_FRAGMENT)) {
            if (this.webFragment == null) {
                this.webFragment = new WebFragment(this.dest.getName());
            }
            this.webFragment.merge(in, source);
            return;
        }
        List<String> duplicate = once.get(entry.getName());
        if (duplicate != null) {
            if (duplicate.contains(source)) {
                System.out.println("!!! SKIP Duplicate[" + entry.getName() + "] in " + source);
            } else {
                duplicate.add(source);
                System.out.println("!!! SKIP Duplicate: " + entry.getName() + " in " + duplicate);
            }
            return;
        }
        duplicate = new LinkedList<String>();
        duplicate.add(source);
        once.put(entry.getName(), duplicate);
        MergeServicesTask.addToZipFile(source, entry, zos, in);
    }

    private void addFromZip(ZipOutputStream zos, File file, Map<String, String> services, Map<String, List<String>> once) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                ZipEntry newEntry = new ZipEntry(entry.getName());
                newEntry.setTime(entry.getTime());
                newEntry.setSize(entry.getSize());
                newEntry.setComment(file.getName());
                InputStream s = zip.getInputStream(entry);
                try {
                    this.addEntryContent(zos, newEntry, s, services, once, file.getAbsolutePath());
                }
                finally {
                    if (s == null) continue;
                    s.close();
                }
            }
        }
    }

    private void addFromFile(ZipOutputStream zos, FileResource resource, Map<String, String> services, Map<String, List<String>> once) throws IOException {
        ZipEntry entry = new ZipEntry(resource.getName().replace('\\', '/'));
        entry.setTime(resource.getLastModified());
        try (InputStream in = resource.getInputStream();){
            this.addEntryContent(zos, entry, in, services, once, resource.getName());
        }
    }

    public void execute() throws BuildException {
        File destination;
        HashMap<String, List<String>> once = new HashMap<String, List<String>>();
        HashMap<String, String> services = new HashMap<String, String>();
        if (this.dest.isDirectory()) {
            destination = new File(this.dest, "temp.jar");
            if (destination.exists()) {
                throw new BuildException("Cannot write to existing temporary file: " + destination.getAbsolutePath());
            }
        } else {
            destination = this.dest;
        }
        try (FileOutputStream fos = new FileOutputStream(destination, false);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (FileSet fileSet : this.filesets) {
                DirectoryScanner ds = fileSet.getDirectoryScanner();
                FileResourceIterator iter = new FileResourceIterator(fileSet.getDir(), ds.getIncludedFiles());
                while (iter.hasNext()) {
                    FileResource resource = (FileResource)iter.next();
                    File file = resource.getFile();
                    String name = file.getName();
                    if (name.endsWith(".jar") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".ear")) {
                        this.addFromZip(zos, file, services, once);
                        continue;
                    }
                    this.addFromFile(zos, resource, services, once);
                }
            }
            for (Map.Entry entry : services.entrySet()) {
                zos.putNextEntry(new ZipEntry((String)entry.getKey()));
                zos.write(((String)entry.getValue()).getBytes());
            }
            if (this.webFragment != null) {
                zos.putNextEntry(new ZipEntry(WEB_FRAGMENT));
                this.webFragment.store(zos);
            }
            zos.putNextEntry(new ZipEntry("META-INF/resources/"));
            zos.putNextEntry(new ZipEntry("META-INF/resources/WEB-INF/"));
            zos.putNextEntry(new ZipEntry("META-INF/resources/WEB-INF/tlds"));
        }
        catch (Exception e) {
            throw new BuildException("Error writing " + destination.getAbsolutePath(), (Throwable)e);
        }
        if (this.dest.isDirectory()) {
            try (FileSystem zipFs = FileSystems.newFileSystem(destination.toPath(), null);){
                for (Path root : zipFs.getRootDirectories()) {
                    Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (!file.startsWith("/META-INF")) {
                                return super.visitFile(file, attrs);
                            }
                            Path newPath = Paths.get(MergeServicesTask.this.dest.getPath(), file.toString());
                            Files.copy(file, newPath, new CopyOption[0]);
                            newPath.toFile().setLastModified(attrs.lastModifiedTime().toMillis());
                            return super.visitFile(file, attrs);
                        }

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            if (!dir.startsWith("/META-INF")) {
                                return super.visitFile(dir, attrs);
                            }
                            Path newPath = Paths.get(MergeServicesTask.this.dest.getPath(), dir.toString());
                            File file = newPath.toFile();
                            if (!attrs.isDirectory()) {
                                file = file.getParentFile();
                            }
                            if (file.mkdirs() && attrs.lastModifiedTime().toMillis() > 0L) {
                                file.setLastModified(attrs.lastModifiedTime().toMillis());
                            }
                            return super.preVisitDirectory(dir, attrs);
                        }
                    });
                }
            }
            catch (Exception e) {
                throw new BuildException("Error writing " + this.dest.getAbsolutePath(), (Throwable)e);
            }
            destination.delete();
        }
    }

    public static class Exclude {
        public String name;

        public void setName(String name) {
            this.name = name;
        }
    }
}

