/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.flatlaf;

import com.formdev.flatlaf.ui.FlatComboBoxUI;
import com.formdev.flatlaf.ui.FlatTextBorder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;

public class JosmFlatComboBoxUI
extends FlatComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new JosmFlatComboBoxUI();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        ComboBoxEditor comboBoxEditor = super.createEditor();
        Component editor = comboBoxEditor.getEditorComponent();
        if (editor instanceof JTextField) {
            JTextField textField = (JTextField)editor;
            editor.addPropertyChangeListener(e -> {
                String propertyName = e.getPropertyName();
                if ("border".equals(propertyName)) {
                    Object newBorder = e.getNewValue();
                    if (newBorder instanceof LineBorder) {
                        Color borderColor = ((LineBorder)newBorder).getLineColor();
                        this.comboBox.putClientProperty("JComponent.outline", borderColor);
                        textField.setBorder(BorderFactory.createEmptyBorder());
                    } else if (newBorder instanceof FlatTextBorder) {
                        textField.setBorder(BorderFactory.createEmptyBorder());
                    } else if (newBorder == null) {
                        this.comboBox.putClientProperty("JComponent.outline", null);
                    }
                } else if ("background".equals(propertyName)) {
                    this.comboBox.setBackground((Color)e.getNewValue());
                }
            });
        }
        return comboBoxEditor;
    }
}

