/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264ReferenceInfoFlags;

public class StdVideoEncodeH264ReferenceInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FRAMENUM;
    public static final int PICORDERCNT;
    public static final int LONG_TERM_PIC_NUM;
    public static final int LONG_TERM_FRAME_IDX;

    public StdVideoEncodeH264ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH264ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264ReferenceInfoFlags flags() {
        return StdVideoEncodeH264ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int FrameNum() {
        return StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCnt() {
        return StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address());
    }

    @NativeType(value="uint16_t")
    public short long_term_pic_num() {
        return StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address());
    }

    @NativeType(value="uint16_t")
    public short long_term_frame_idx() {
        return StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address());
    }

    public StdVideoEncodeH264ReferenceInfo flags(StdVideoEncodeH264ReferenceInfoFlags value) {
        StdVideoEncodeH264ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo flags(Consumer<StdVideoEncodeH264ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo FrameNum(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo PicOrderCnt(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo long_term_pic_num(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo long_term_frame_idx(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo set(StdVideoEncodeH264ReferenceInfoFlags flags, int FrameNum, int PicOrderCnt, short long_term_pic_num, short long_term_frame_idx) {
        this.flags(flags);
        this.FrameNum(FrameNum);
        this.PicOrderCnt(PicOrderCnt);
        this.long_term_pic_num(long_term_pic_num);
        this.long_term_frame_idx(long_term_frame_idx);
        return this;
    }

    public StdVideoEncodeH264ReferenceInfo set(StdVideoEncodeH264ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264ReferenceInfo malloc() {
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static StdVideoEncodeH264ReferenceInfo calloc() {
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static StdVideoEncodeH264ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH264ReferenceInfo create(long address) {
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, address);
    }

    @Nullable
    public static StdVideoEncodeH264ReferenceInfo createSafe(long address) {
        return address == 0L ? null : StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(StdVideoEncodeH264ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264ReferenceInfo.__create(capacity, SIZEOF);
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, address, capacity);
    }

    public static StdVideoEncodeH264ReferenceInfo malloc(MemoryStack stack) {
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static StdVideoEncodeH264ReferenceInfo calloc(MemoryStack stack) {
        return StdVideoEncodeH264ReferenceInfo.wrap(StdVideoEncodeH264ReferenceInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return StdVideoEncodeH264ReferenceInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeH264ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nFrameNum(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMENUM);
    }

    public static int nPicOrderCnt(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICORDERCNT);
    }

    public static short nlong_term_pic_num(long struct) {
        return UNSAFE.getShort(null, struct + (long)LONG_TERM_PIC_NUM);
    }

    public static short nlong_term_frame_idx(long struct) {
        return UNSAFE.getShort(null, struct + (long)LONG_TERM_FRAME_IDX);
    }

    public static void nflags(long struct, StdVideoEncodeH264ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH264ReferenceInfoFlags.SIZEOF);
    }

    public static void nFrameNum(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMENUM, value);
    }

    public static void nPicOrderCnt(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICORDERCNT, value);
    }

    public static void nlong_term_pic_num(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LONG_TERM_PIC_NUM, value);
    }

    public static void nlong_term_frame_idx(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)LONG_TERM_FRAME_IDX, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264ReferenceInfo.__struct(StdVideoEncodeH264ReferenceInfo.__member(StdVideoEncodeH264ReferenceInfoFlags.SIZEOF, StdVideoEncodeH264ReferenceInfoFlags.ALIGNOF), StdVideoEncodeH264ReferenceInfo.__member(4), StdVideoEncodeH264ReferenceInfo.__member(4), StdVideoEncodeH264ReferenceInfo.__member(2), StdVideoEncodeH264ReferenceInfo.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FRAMENUM = layout.offsetof(1);
        PICORDERCNT = layout.offsetof(2);
        LONG_TERM_PIC_NUM = layout.offsetof(3);
        LONG_TERM_FRAME_IDX = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeH264ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoEncodeH264ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264ReferenceInfoFlags flags() {
            return StdVideoEncodeH264ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int FrameNum() {
            return StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCnt() {
            return StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address());
        }

        @NativeType(value="uint16_t")
        public short long_term_pic_num() {
            return StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address());
        }

        @NativeType(value="uint16_t")
        public short long_term_frame_idx() {
            return StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address());
        }

        public Buffer flags(StdVideoEncodeH264ReferenceInfoFlags value) {
            StdVideoEncodeH264ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer FrameNum(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264ReferenceInfo.nFrameNum(this.address(), value);
            return this;
        }

        public Buffer PicOrderCnt(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH264ReferenceInfo.nPicOrderCnt(this.address(), value);
            return this;
        }

        public Buffer long_term_pic_num(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264ReferenceInfo.nlong_term_pic_num(this.address(), value);
            return this;
        }

        public Buffer long_term_frame_idx(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH264ReferenceInfo.nlong_term_frame_idx(this.address(), value);
            return this;
        }
    }
}

