/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkMemoryRequirements2;

public class VkVideoGetMemoryPropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYBINDINDEX;
    public static final int PMEMORYREQUIREMENTS;

    public VkVideoGetMemoryPropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoGetMemoryPropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoGetMemoryPropertiesKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoGetMemoryPropertiesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryBindIndex() {
        return VkVideoGetMemoryPropertiesKHR.nmemoryBindIndex(this.address());
    }

    @NativeType(value="VkMemoryRequirements2 *")
    public VkMemoryRequirements2 pMemoryRequirements() {
        return VkVideoGetMemoryPropertiesKHR.npMemoryRequirements(this.address());
    }

    public VkVideoGetMemoryPropertiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoGetMemoryPropertiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoGetMemoryPropertiesKHR sType$Default() {
        return this.sType(1000023003);
    }

    public VkVideoGetMemoryPropertiesKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoGetMemoryPropertiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoGetMemoryPropertiesKHR memoryBindIndex(@NativeType(value="uint32_t") int value) {
        VkVideoGetMemoryPropertiesKHR.nmemoryBindIndex(this.address(), value);
        return this;
    }

    public VkVideoGetMemoryPropertiesKHR pMemoryRequirements(@NativeType(value="VkMemoryRequirements2 *") VkMemoryRequirements2 value) {
        VkVideoGetMemoryPropertiesKHR.npMemoryRequirements(this.address(), value);
        return this;
    }

    public VkVideoGetMemoryPropertiesKHR set(int sType, long pNext, int memoryBindIndex, VkMemoryRequirements2 pMemoryRequirements) {
        this.sType(sType);
        this.pNext(pNext);
        this.memoryBindIndex(memoryBindIndex);
        this.pMemoryRequirements(pMemoryRequirements);
        return this;
    }

    public VkVideoGetMemoryPropertiesKHR set(VkVideoGetMemoryPropertiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoGetMemoryPropertiesKHR malloc() {
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkVideoGetMemoryPropertiesKHR calloc() {
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkVideoGetMemoryPropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkVideoGetMemoryPropertiesKHR create(long address) {
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, address);
    }

    @Nullable
    public static VkVideoGetMemoryPropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkVideoGetMemoryPropertiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoGetMemoryPropertiesKHR.__create(capacity, SIZEOF);
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkVideoGetMemoryPropertiesKHR malloc(MemoryStack stack) {
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoGetMemoryPropertiesKHR calloc(MemoryStack stack) {
        return VkVideoGetMemoryPropertiesKHR.wrap(VkVideoGetMemoryPropertiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkVideoGetMemoryPropertiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nmemoryBindIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMORYBINDINDEX);
    }

    public static VkMemoryRequirements2 npMemoryRequirements(long struct) {
        return VkMemoryRequirements2.create(MemoryUtil.memGetAddress(struct + (long)PMEMORYREQUIREMENTS));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmemoryBindIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MEMORYBINDINDEX, value);
    }

    public static void npMemoryRequirements(long struct, VkMemoryRequirements2 value) {
        MemoryUtil.memPutAddress(struct + (long)PMEMORYREQUIREMENTS, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PMEMORYREQUIREMENTS));
    }

    static {
        Struct.Layout layout = VkVideoGetMemoryPropertiesKHR.__struct(VkVideoGetMemoryPropertiesKHR.__member(4), VkVideoGetMemoryPropertiesKHR.__member(POINTER_SIZE), VkVideoGetMemoryPropertiesKHR.__member(4), VkVideoGetMemoryPropertiesKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYBINDINDEX = layout.offsetof(2);
        PMEMORYREQUIREMENTS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkVideoGetMemoryPropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkVideoGetMemoryPropertiesKHR ELEMENT_FACTORY = VkVideoGetMemoryPropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoGetMemoryPropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoGetMemoryPropertiesKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoGetMemoryPropertiesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryBindIndex() {
            return VkVideoGetMemoryPropertiesKHR.nmemoryBindIndex(this.address());
        }

        @NativeType(value="VkMemoryRequirements2 *")
        public VkMemoryRequirements2 pMemoryRequirements() {
            return VkVideoGetMemoryPropertiesKHR.npMemoryRequirements(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoGetMemoryPropertiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoGetMemoryPropertiesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer memoryBindIndex(@NativeType(value="uint32_t") int value) {
            VkVideoGetMemoryPropertiesKHR.nmemoryBindIndex(this.address(), value);
            return this;
        }

        public Buffer pMemoryRequirements(@NativeType(value="VkMemoryRequirements2 *") VkMemoryRequirements2 value) {
            VkVideoGetMemoryPropertiesKHR.npMemoryRequirements(this.address(), value);
            return this;
        }
    }
}

