/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilitiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;

    public VkSurfaceCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSurfaceCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageCount() {
        return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageArrayLayers() {
        return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagsKHR")
    public int supportedTransforms() {
        return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int currentTransform() {
        return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagsKHR")
    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int supportedUsageFlags() {
        return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
    }

    public static VkSurfaceCapabilitiesKHR malloc() {
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR calloc() {
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSurfaceCapabilitiesKHR create(long address) {
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, address);
    }

    @Nullable
    public static VkSurfaceCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSurfaceCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceCapabilitiesKHR.__create(capacity, SIZEOF);
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSurfaceCapabilitiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR mallocStack() {
        return VkSurfaceCapabilitiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR callocStack() {
        return VkSurfaceCapabilitiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.calloc(capacity, stack);
    }

    public static VkSurfaceCapabilitiesKHR malloc(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSurfaceCapabilitiesKHR calloc(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.wrap(VkSurfaceCapabilitiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nminImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilitiesKHR.__struct(VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINIMAGECOUNT = layout.offsetof(0);
        MAXIMAGECOUNT = layout.offsetof(1);
        CURRENTEXTENT = layout.offsetof(2);
        MINIMAGEEXTENT = layout.offsetof(3);
        MAXIMAGEEXTENT = layout.offsetof(4);
        MAXIMAGEARRAYLAYERS = layout.offsetof(5);
        SUPPORTEDTRANSFORMS = layout.offsetof(6);
        CURRENTTRANSFORM = layout.offsetof(7);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(8);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkSurfaceCapabilitiesKHR ELEMENT_FACTORY = VkSurfaceCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSurfaceCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageCount() {
            return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageArrayLayers() {
            return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagsKHR")
        public int supportedTransforms() {
            return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int currentTransform() {
            return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagsKHR")
        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int supportedUsageFlags() {
            return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
        }
    }
}

