/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubresourceLayout
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int SIZE;
    public static final int ROWPITCH;
    public static final int ARRAYPITCH;
    public static final int DEPTHPITCH;

    public VkSubresourceLayout(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubresourceLayout.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkSubresourceLayout.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSubresourceLayout.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long rowPitch() {
        return VkSubresourceLayout.nrowPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long arrayPitch() {
        return VkSubresourceLayout.narrayPitch(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long depthPitch() {
        return VkSubresourceLayout.ndepthPitch(this.address());
    }

    public static VkSubresourceLayout malloc() {
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSubresourceLayout calloc() {
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSubresourceLayout create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSubresourceLayout create(long address) {
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, address);
    }

    @Nullable
    public static VkSubresourceLayout createSafe(long address) {
        return address == 0L ? null : VkSubresourceLayout.wrap(VkSubresourceLayout.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSubresourceLayout.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSubresourceLayout.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSubresourceLayout.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubresourceLayout.__create(capacity, SIZEOF);
        return VkSubresourceLayout.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSubresourceLayout.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSubresourceLayout.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSubresourceLayout mallocStack() {
        return VkSubresourceLayout.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubresourceLayout callocStack() {
        return VkSubresourceLayout.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubresourceLayout mallocStack(MemoryStack stack) {
        return VkSubresourceLayout.malloc(stack);
    }

    @Deprecated
    public static VkSubresourceLayout callocStack(MemoryStack stack) {
        return VkSubresourceLayout.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubresourceLayout.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubresourceLayout.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.calloc(capacity, stack);
    }

    public static VkSubresourceLayout malloc(MemoryStack stack) {
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSubresourceLayout calloc(MemoryStack stack) {
        return VkSubresourceLayout.wrap(VkSubresourceLayout.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSubresourceLayout.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long noffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)OFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nrowPitch(long struct) {
        return UNSAFE.getLong(null, struct + (long)ROWPITCH);
    }

    public static long narrayPitch(long struct) {
        return UNSAFE.getLong(null, struct + (long)ARRAYPITCH);
    }

    public static long ndepthPitch(long struct) {
        return UNSAFE.getLong(null, struct + (long)DEPTHPITCH);
    }

    static {
        Struct.Layout layout = VkSubresourceLayout.__struct(VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8), VkSubresourceLayout.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        ROWPITCH = layout.offsetof(2);
        ARRAYPITCH = layout.offsetof(3);
        DEPTHPITCH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSubresourceLayout, Buffer>
    implements NativeResource {
        private static final VkSubresourceLayout ELEMENT_FACTORY = VkSubresourceLayout.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSubresourceLayout getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkSubresourceLayout.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSubresourceLayout.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long rowPitch() {
            return VkSubresourceLayout.nrowPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long arrayPitch() {
            return VkSubresourceLayout.narrayPitch(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long depthPitch() {
            return VkSubresourceLayout.ndepthPitch(this.address());
        }
    }
}

