/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSparseMemoryBind
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESOURCEOFFSET;
    public static final int SIZE;
    public static final int MEMORY;
    public static final int MEMORYOFFSET;
    public static final int FLAGS;

    public VkSparseMemoryBind(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseMemoryBind.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long resourceOffset() {
        return VkSparseMemoryBind.nresourceOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSparseMemoryBind.nsize(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkSparseMemoryBind.nmemory(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long memoryOffset() {
        return VkSparseMemoryBind.nmemoryOffset(this.address());
    }

    @NativeType(value="VkSparseMemoryBindFlags")
    public int flags() {
        return VkSparseMemoryBind.nflags(this.address());
    }

    public VkSparseMemoryBind resourceOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nresourceOffset(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind size(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nsize(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind memory(@NativeType(value="VkDeviceMemory") long value) {
        VkSparseMemoryBind.nmemory(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind memoryOffset(@NativeType(value="VkDeviceSize") long value) {
        VkSparseMemoryBind.nmemoryOffset(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
        VkSparseMemoryBind.nflags(this.address(), value);
        return this;
    }

    public VkSparseMemoryBind set(long resourceOffset, long size, long memory, long memoryOffset, int flags) {
        this.resourceOffset(resourceOffset);
        this.size(size);
        this.memory(memory);
        this.memoryOffset(memoryOffset);
        this.flags(flags);
        return this;
    }

    public VkSparseMemoryBind set(VkSparseMemoryBind src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseMemoryBind malloc() {
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseMemoryBind calloc() {
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseMemoryBind create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSparseMemoryBind create(long address) {
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, address);
    }

    @Nullable
    public static VkSparseMemoryBind createSafe(long address) {
        return address == 0L ? null : VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseMemoryBind.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSparseMemoryBind.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseMemoryBind.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseMemoryBind.__create(capacity, SIZEOF);
        return VkSparseMemoryBind.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSparseMemoryBind.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseMemoryBind.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSparseMemoryBind mallocStack() {
        return VkSparseMemoryBind.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseMemoryBind callocStack() {
        return VkSparseMemoryBind.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseMemoryBind mallocStack(MemoryStack stack) {
        return VkSparseMemoryBind.malloc(stack);
    }

    @Deprecated
    public static VkSparseMemoryBind callocStack(MemoryStack stack) {
        return VkSparseMemoryBind.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseMemoryBind.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseMemoryBind.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.calloc(capacity, stack);
    }

    public static VkSparseMemoryBind malloc(MemoryStack stack) {
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseMemoryBind calloc(MemoryStack stack) {
        return VkSparseMemoryBind.wrap(VkSparseMemoryBind.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSparseMemoryBind.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nresourceOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)RESOURCEOFFSET);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nmemory(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORY);
    }

    public static long nmemoryOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)MEMORYOFFSET);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nresourceOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RESOURCEOFFSET, value);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nmemory(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORY, value);
    }

    public static void nmemoryOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MEMORYOFFSET, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSparseMemoryBind.__struct(VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(8), VkSparseMemoryBind.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESOURCEOFFSET = layout.offsetof(0);
        SIZE = layout.offsetof(1);
        MEMORY = layout.offsetof(2);
        MEMORYOFFSET = layout.offsetof(3);
        FLAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkSparseMemoryBind, Buffer>
    implements NativeResource {
        private static final VkSparseMemoryBind ELEMENT_FACTORY = VkSparseMemoryBind.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSparseMemoryBind getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long resourceOffset() {
            return VkSparseMemoryBind.nresourceOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSparseMemoryBind.nsize(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkSparseMemoryBind.nmemory(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long memoryOffset() {
            return VkSparseMemoryBind.nmemoryOffset(this.address());
        }

        @NativeType(value="VkSparseMemoryBindFlags")
        public int flags() {
            return VkSparseMemoryBind.nflags(this.address());
        }

        public Buffer resourceOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nresourceOffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nsize(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkSparseMemoryBind.nmemory(this.address(), value);
            return this;
        }

        public Buffer memoryOffset(@NativeType(value="VkDeviceSize") long value) {
            VkSparseMemoryBind.nmemoryOffset(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkSparseMemoryBindFlags") int value) {
            VkSparseMemoryBind.nflags(this.address(), value);
            return this;
        }
    }
}

