/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageMemoryRequirements;

public class VkSparseImageMemoryRequirements2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MEMORYREQUIREMENTS;

    public VkSparseImageMemoryRequirements2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseImageMemoryRequirements2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSparseImageMemoryRequirements2.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkSparseImageMemoryRequirements2.npNext(this.address());
    }

    public VkSparseImageMemoryRequirements memoryRequirements() {
        return VkSparseImageMemoryRequirements2.nmemoryRequirements(this.address());
    }

    public VkSparseImageMemoryRequirements2 sType(@NativeType(value="VkStructureType") int value) {
        VkSparseImageMemoryRequirements2.nsType(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryRequirements2 sType$Default() {
        return this.sType(1000146004);
    }

    public VkSparseImageMemoryRequirements2 pNext(@NativeType(value="void *") long value) {
        VkSparseImageMemoryRequirements2.npNext(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryRequirements2 set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSparseImageMemoryRequirements2 set(VkSparseImageMemoryRequirements2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryRequirements2 malloc() {
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2 calloc() {
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSparseImageMemoryRequirements2 create(long address) {
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, address);
    }

    @Nullable
    public static VkSparseImageMemoryRequirements2 createSafe(long address) {
        return address == 0L ? null : VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSparseImageMemoryRequirements2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryRequirements2.__create(capacity, SIZEOF);
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSparseImageMemoryRequirements2.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements2 mallocStack() {
        return VkSparseImageMemoryRequirements2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements2 callocStack() {
        return VkSparseImageMemoryRequirements2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements2 mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageMemoryRequirements2 callocStack(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryRequirements2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryRequirements2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.calloc(capacity, stack);
    }

    public static VkSparseImageMemoryRequirements2 malloc(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSparseImageMemoryRequirements2 calloc(MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.wrap(VkSparseImageMemoryRequirements2.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryRequirements2.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkSparseImageMemoryRequirements nmemoryRequirements(long struct) {
        return VkSparseImageMemoryRequirements.create(struct + (long)MEMORYREQUIREMENTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryRequirements2.__struct(VkSparseImageMemoryRequirements2.__member(4), VkSparseImageMemoryRequirements2.__member(POINTER_SIZE), VkSparseImageMemoryRequirements2.__member(VkSparseImageMemoryRequirements.SIZEOF, VkSparseImageMemoryRequirements.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MEMORYREQUIREMENTS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryRequirements2, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryRequirements2 ELEMENT_FACTORY = VkSparseImageMemoryRequirements2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSparseImageMemoryRequirements2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSparseImageMemoryRequirements2.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkSparseImageMemoryRequirements2.npNext(this.address());
        }

        public VkSparseImageMemoryRequirements memoryRequirements() {
            return VkSparseImageMemoryRequirements2.nmemoryRequirements(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSparseImageMemoryRequirements2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000146004);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSparseImageMemoryRequirements2.npNext(this.address(), value);
            return this;
        }
    }
}

