/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSemaphoreTypeCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SEMAPHORETYPE;
    public static final int INITIALVALUE;

    public VkSemaphoreTypeCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSemaphoreTypeCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreTypeCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreTypeCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphoreType")
    public int semaphoreType() {
        return VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address());
    }

    @NativeType(value="uint64_t")
    public long initialValue() {
        return VkSemaphoreTypeCreateInfo.ninitialValue(this.address());
    }

    public VkSemaphoreTypeCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreTypeCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo sType$Default() {
        return this.sType(1000207002);
    }

    public VkSemaphoreTypeCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreTypeCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo semaphoreType(@NativeType(value="VkSemaphoreType") int value) {
        VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo initialValue(@NativeType(value="uint64_t") long value) {
        VkSemaphoreTypeCreateInfo.ninitialValue(this.address(), value);
        return this;
    }

    public VkSemaphoreTypeCreateInfo set(int sType, long pNext, int semaphoreType, long initialValue) {
        this.sType(sType);
        this.pNext(pNext);
        this.semaphoreType(semaphoreType);
        this.initialValue(initialValue);
        return this;
    }

    public VkSemaphoreTypeCreateInfo set(VkSemaphoreTypeCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSemaphoreTypeCreateInfo malloc() {
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo calloc() {
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSemaphoreTypeCreateInfo create(long address) {
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, address);
    }

    @Nullable
    public static VkSemaphoreTypeCreateInfo createSafe(long address) {
        return address == 0L ? null : VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSemaphoreTypeCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSemaphoreTypeCreateInfo.__create(capacity, SIZEOF);
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSemaphoreTypeCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VkSemaphoreTypeCreateInfo malloc(MemoryStack stack) {
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSemaphoreTypeCreateInfo calloc(MemoryStack stack) {
        return VkSemaphoreTypeCreateInfo.wrap(VkSemaphoreTypeCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSemaphoreTypeCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsemaphoreType(long struct) {
        return UNSAFE.getInt(null, struct + (long)SEMAPHORETYPE);
    }

    public static long ninitialValue(long struct) {
        return UNSAFE.getLong(null, struct + (long)INITIALVALUE);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsemaphoreType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SEMAPHORETYPE, value);
    }

    public static void ninitialValue(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)INITIALVALUE, value);
    }

    static {
        Struct.Layout layout = VkSemaphoreTypeCreateInfo.__struct(VkSemaphoreTypeCreateInfo.__member(4), VkSemaphoreTypeCreateInfo.__member(POINTER_SIZE), VkSemaphoreTypeCreateInfo.__member(4), VkSemaphoreTypeCreateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SEMAPHORETYPE = layout.offsetof(2);
        INITIALVALUE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreTypeCreateInfo, Buffer>
    implements NativeResource {
        private static final VkSemaphoreTypeCreateInfo ELEMENT_FACTORY = VkSemaphoreTypeCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSemaphoreTypeCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreTypeCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreTypeCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphoreType")
        public int semaphoreType() {
            return VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address());
        }

        @NativeType(value="uint64_t")
        public long initialValue() {
            return VkSemaphoreTypeCreateInfo.ninitialValue(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreTypeCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000207002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreTypeCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer semaphoreType(@NativeType(value="VkSemaphoreType") int value) {
            VkSemaphoreTypeCreateInfo.nsemaphoreType(this.address(), value);
            return this;
        }

        public Buffer initialValue(@NativeType(value="uint64_t") long value) {
            VkSemaphoreTypeCreateInfo.ninitialValue(this.address(), value);
            return this;
        }
    }
}

