/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExportSemaphoreCreateInfo;
import org.lwjgl.vulkan.VkExportSemaphoreCreateInfoKHR;
import org.lwjgl.vulkan.VkExportSemaphoreWin32HandleInfoKHR;
import org.lwjgl.vulkan.VkSemaphoreTypeCreateInfo;
import org.lwjgl.vulkan.VkSemaphoreTypeCreateInfoKHR;

public class VkSemaphoreCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;

    public VkSemaphoreCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSemaphoreCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphoreCreateFlags")
    public int flags() {
        return VkSemaphoreCreateInfo.nflags(this.address());
    }

    public VkSemaphoreCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo sType$Default() {
        return this.sType(9);
    }

    public VkSemaphoreCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo pNext(VkExportSemaphoreCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSemaphoreCreateInfo pNext(VkExportSemaphoreCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSemaphoreCreateInfo pNext(VkExportSemaphoreWin32HandleInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSemaphoreCreateInfo pNext(VkSemaphoreTypeCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSemaphoreCreateInfo pNext(VkSemaphoreTypeCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkSemaphoreCreateInfo flags(@NativeType(value="VkSemaphoreCreateFlags") int value) {
        VkSemaphoreCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkSemaphoreCreateInfo set(int sType, long pNext, int flags) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        return this;
    }

    public VkSemaphoreCreateInfo set(VkSemaphoreCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSemaphoreCreateInfo malloc() {
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkSemaphoreCreateInfo calloc() {
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkSemaphoreCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkSemaphoreCreateInfo create(long address) {
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, address);
    }

    @Nullable
    public static VkSemaphoreCreateInfo createSafe(long address) {
        return address == 0L ? null : VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkSemaphoreCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkSemaphoreCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkSemaphoreCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSemaphoreCreateInfo.__create(capacity, SIZEOF);
        return VkSemaphoreCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkSemaphoreCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkSemaphoreCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkSemaphoreCreateInfo mallocStack() {
        return VkSemaphoreCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSemaphoreCreateInfo callocStack() {
        return VkSemaphoreCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSemaphoreCreateInfo mallocStack(MemoryStack stack) {
        return VkSemaphoreCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkSemaphoreCreateInfo callocStack(MemoryStack stack) {
        return VkSemaphoreCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSemaphoreCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSemaphoreCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.calloc(capacity, stack);
    }

    public static VkSemaphoreCreateInfo malloc(MemoryStack stack) {
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkSemaphoreCreateInfo calloc(MemoryStack stack) {
        return VkSemaphoreCreateInfo.wrap(VkSemaphoreCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkSemaphoreCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = VkSemaphoreCreateInfo.__struct(VkSemaphoreCreateInfo.__member(4), VkSemaphoreCreateInfo.__member(POINTER_SIZE), VkSemaphoreCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreCreateInfo, Buffer>
    implements NativeResource {
        private static final VkSemaphoreCreateInfo ELEMENT_FACTORY = VkSemaphoreCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSemaphoreCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphoreCreateFlags")
        public int flags() {
            return VkSemaphoreCreateInfo.nflags(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(9);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportSemaphoreCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportSemaphoreCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkExportSemaphoreWin32HandleInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSemaphoreTypeCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSemaphoreTypeCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkSemaphoreCreateFlags") int value) {
            VkSemaphoreCreateInfo.nflags(this.address(), value);
            return this;
        }
    }
}

