/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkRenderingAttachmentInfo;
import org.lwjgl.vulkan.VkRenderingInfo;

public class VkRenderingInfoKHR
extends VkRenderingInfo {
    public VkRenderingInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderingInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR sType$Default() {
        return this.sType(1000044000);
    }

    @Override
    public VkRenderingInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderingInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR flags(@NativeType(value="VkRenderingFlags") int value) {
        VkRenderingInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR renderArea(VkRect2D value) {
        VkRenderingInfoKHR.nrenderArea(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR renderArea(Consumer<VkRect2D> consumer) {
        consumer.accept(this.renderArea());
        return this;
    }

    @Override
    public VkRenderingInfoKHR layerCount(@NativeType(value="uint32_t") int value) {
        VkRenderingInfoKHR.nlayerCount(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR viewMask(@NativeType(value="uint32_t") int value) {
        VkRenderingInfoKHR.nviewMask(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR pColorAttachments(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo.Buffer value) {
        VkRenderingInfoKHR.npColorAttachments(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR pDepthAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
        VkRenderingInfoKHR.npDepthAttachment(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR pStencilAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
        VkRenderingInfoKHR.npStencilAttachment(this.address(), value);
        return this;
    }

    @Override
    public VkRenderingInfoKHR set(int sType, long pNext, int flags, VkRect2D renderArea, int layerCount, int viewMask, @Nullable VkRenderingAttachmentInfo.Buffer pColorAttachments, @Nullable VkRenderingAttachmentInfo pDepthAttachment, @Nullable VkRenderingAttachmentInfo pStencilAttachment) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.renderArea(renderArea);
        this.layerCount(layerCount);
        this.viewMask(viewMask);
        this.pColorAttachments(pColorAttachments);
        this.pDepthAttachment(pDepthAttachment);
        this.pStencilAttachment(pStencilAttachment);
        return this;
    }

    public VkRenderingInfoKHR set(VkRenderingInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderingInfoKHR malloc() {
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkRenderingInfoKHR calloc() {
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkRenderingInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkRenderingInfoKHR create(long address) {
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, address);
    }

    @Nullable
    public static VkRenderingInfoKHR createSafe(long address) {
        return address == 0L ? null : VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderingInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkRenderingInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderingInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingInfoKHR.__create(capacity, SIZEOF);
        return VkRenderingInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkRenderingInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkRenderingInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkRenderingInfoKHR malloc(MemoryStack stack) {
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderingInfoKHR calloc(MemoryStack stack) {
        return VkRenderingInfoKHR.wrap(VkRenderingInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkRenderingInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkRenderingInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkRenderingInfo.Buffer {
        private static final VkRenderingInfoKHR ELEMENT_FACTORY = VkRenderingInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderingInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000044000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkRenderingFlags") int value) {
            VkRenderingInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer renderArea(VkRect2D value) {
            VkRenderingInfoKHR.nrenderArea(this.address(), value);
            return this;
        }

        @Override
        public Buffer renderArea(Consumer<VkRect2D> consumer) {
            consumer.accept(this.renderArea());
            return this;
        }

        @Override
        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkRenderingInfoKHR.nlayerCount(this.address(), value);
            return this;
        }

        @Override
        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkRenderingInfoKHR.nviewMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer pColorAttachments(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo.Buffer value) {
            VkRenderingInfoKHR.npColorAttachments(this.address(), value);
            return this;
        }

        @Override
        public Buffer pDepthAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
            VkRenderingInfoKHR.npDepthAttachment(this.address(), value);
            return this;
        }

        @Override
        public Buffer pStencilAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
            VkRenderingInfoKHR.npStencilAttachment(this.address(), value);
            return this;
        }
    }
}

