/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceMemoryBudgetPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HEAPBUDGET;
    public static final int HEAPUSAGE;

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapBudget() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapBudget(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
    }

    @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
    public LongBuffer heapUsage() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long heapUsage(int index) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT sType$Default() {
        return this.sType(1000237000);
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceMemoryBudgetPropertiesEXT set(VkPhysicalDeviceMemoryBudgetPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT malloc() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT calloc() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT create(long address) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, address);
    }

    @Nullable
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT createSafe(long address) {
        return address == 0L ? null : VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPhysicalDeviceMemoryBudgetPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__create(capacity, SIZEOF);
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack() {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT callocStack(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT malloc(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceMemoryBudgetPropertiesEXT calloc(MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(VkPhysicalDeviceMemoryBudgetPropertiesEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceMemoryBudgetPropertiesEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static LongBuffer nheapBudget(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)HEAPBUDGET, 16);
    }

    public static long nheapBudget(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)HEAPBUDGET + Checks.check(index, 16) * 8L);
    }

    public static LongBuffer nheapUsage(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)HEAPUSAGE, 16);
    }

    public static long nheapUsage(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)HEAPUSAGE + Checks.check(index, 16) * 8L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceMemoryBudgetPropertiesEXT.__struct(VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member(4), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__member(POINTER_SIZE), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array(8, 16), VkPhysicalDeviceMemoryBudgetPropertiesEXT.__array(8, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HEAPBUDGET = layout.offsetof(2);
        HEAPUSAGE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceMemoryBudgetPropertiesEXT, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceMemoryBudgetPropertiesEXT ELEMENT_FACTORY = VkPhysicalDeviceMemoryBudgetPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPhysicalDeviceMemoryBudgetPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapBudget() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapBudget(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapBudget(this.address(), index);
        }

        @NativeType(value="VkDeviceSize[VK_MAX_MEMORY_HEAPS]")
        public LongBuffer heapUsage() {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long heapUsage(int index) {
            return VkPhysicalDeviceMemoryBudgetPropertiesEXT.nheapUsage(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000237000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceMemoryBudgetPropertiesEXT.npNext(this.address(), value);
            return this;
        }
    }
}

