/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPerformanceValueDataINTEL;

public class VkPerformanceValueINTEL
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DATA;

    public VkPerformanceValueINTEL(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPerformanceValueINTEL.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkPerformanceValueTypeINTEL")
    public int type() {
        return VkPerformanceValueINTEL.ntype(this.address());
    }

    public VkPerformanceValueDataINTEL data() {
        return VkPerformanceValueINTEL.ndata(this.address());
    }

    public VkPerformanceValueINTEL type(@NativeType(value="VkPerformanceValueTypeINTEL") int value) {
        VkPerformanceValueINTEL.ntype(this.address(), value);
        return this;
    }

    public VkPerformanceValueINTEL data(VkPerformanceValueDataINTEL value) {
        VkPerformanceValueINTEL.ndata(this.address(), value);
        return this;
    }

    public VkPerformanceValueINTEL data(Consumer<VkPerformanceValueDataINTEL> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public VkPerformanceValueINTEL set(int type, VkPerformanceValueDataINTEL data) {
        this.type(type);
        this.data(data);
        return this;
    }

    public VkPerformanceValueINTEL set(VkPerformanceValueINTEL src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPerformanceValueINTEL malloc() {
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPerformanceValueINTEL calloc() {
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPerformanceValueINTEL create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPerformanceValueINTEL create(long address) {
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, address);
    }

    @Nullable
    public static VkPerformanceValueINTEL createSafe(long address) {
        return address == 0L ? null : VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPerformanceValueINTEL.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPerformanceValueINTEL.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPerformanceValueINTEL.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPerformanceValueINTEL.__create(capacity, SIZEOF);
        return VkPerformanceValueINTEL.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPerformanceValueINTEL.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPerformanceValueINTEL.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkPerformanceValueINTEL mallocStack() {
        return VkPerformanceValueINTEL.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPerformanceValueINTEL callocStack() {
        return VkPerformanceValueINTEL.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPerformanceValueINTEL mallocStack(MemoryStack stack) {
        return VkPerformanceValueINTEL.malloc(stack);
    }

    @Deprecated
    public static VkPerformanceValueINTEL callocStack(MemoryStack stack) {
        return VkPerformanceValueINTEL.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPerformanceValueINTEL.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPerformanceValueINTEL.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPerformanceValueINTEL.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPerformanceValueINTEL.calloc(capacity, stack);
    }

    public static VkPerformanceValueINTEL malloc(MemoryStack stack) {
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPerformanceValueINTEL calloc(MemoryStack stack) {
        return VkPerformanceValueINTEL.wrap(VkPerformanceValueINTEL.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPerformanceValueINTEL.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPerformanceValueINTEL.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static VkPerformanceValueDataINTEL ndata(long struct) {
        return VkPerformanceValueDataINTEL.create(struct + (long)DATA);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndata(long struct, VkPerformanceValueDataINTEL value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DATA, VkPerformanceValueDataINTEL.SIZEOF);
    }

    static {
        Struct.Layout layout = VkPerformanceValueINTEL.__struct(VkPerformanceValueINTEL.__member(4), VkPerformanceValueINTEL.__member(VkPerformanceValueDataINTEL.SIZEOF, VkPerformanceValueDataINTEL.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPerformanceValueINTEL, Buffer>
    implements NativeResource {
        private static final VkPerformanceValueINTEL ELEMENT_FACTORY = VkPerformanceValueINTEL.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPerformanceValueINTEL getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkPerformanceValueTypeINTEL")
        public int type() {
            return VkPerformanceValueINTEL.ntype(this.address());
        }

        public VkPerformanceValueDataINTEL data() {
            return VkPerformanceValueINTEL.ndata(this.address());
        }

        public Buffer type(@NativeType(value="VkPerformanceValueTypeINTEL") int value) {
            VkPerformanceValueINTEL.ntype(this.address(), value);
            return this;
        }

        public Buffer data(VkPerformanceValueDataINTEL value) {
            VkPerformanceValueINTEL.ndata(this.address(), value);
            return this;
        }

        public Buffer data(Consumer<VkPerformanceValueDataINTEL> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

