/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPerformanceCounterKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int UNIT;
    public static final int SCOPE;
    public static final int STORAGE;
    public static final int UUID;

    public VkPerformanceCounterKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPerformanceCounterKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPerformanceCounterKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPerformanceCounterKHR.npNext(this.address());
    }

    @NativeType(value="VkPerformanceCounterUnitKHR")
    public int unit() {
        return VkPerformanceCounterKHR.nunit(this.address());
    }

    @NativeType(value="VkPerformanceCounterScopeKHR")
    public int scope() {
        return VkPerformanceCounterKHR.nscope(this.address());
    }

    @NativeType(value="VkPerformanceCounterStorageKHR")
    public int storage() {
        return VkPerformanceCounterKHR.nstorage(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer uuid() {
        return VkPerformanceCounterKHR.nuuid(this.address());
    }

    @NativeType(value="uint8_t")
    public byte uuid(int index) {
        return VkPerformanceCounterKHR.nuuid(this.address(), index);
    }

    public VkPerformanceCounterKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPerformanceCounterKHR.nsType(this.address(), value);
        return this;
    }

    public VkPerformanceCounterKHR sType$Default() {
        return this.sType(1000116005);
    }

    public VkPerformanceCounterKHR pNext(@NativeType(value="void *") long value) {
        VkPerformanceCounterKHR.npNext(this.address(), value);
        return this;
    }

    public VkPerformanceCounterKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPerformanceCounterKHR set(VkPerformanceCounterKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPerformanceCounterKHR malloc() {
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkPerformanceCounterKHR calloc() {
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkPerformanceCounterKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkPerformanceCounterKHR create(long address) {
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, address);
    }

    @Nullable
    public static VkPerformanceCounterKHR createSafe(long address) {
        return address == 0L ? null : VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkPerformanceCounterKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkPerformanceCounterKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkPerformanceCounterKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPerformanceCounterKHR.__create(capacity, SIZEOF);
        return VkPerformanceCounterKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkPerformanceCounterKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkPerformanceCounterKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkPerformanceCounterKHR malloc(MemoryStack stack) {
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPerformanceCounterKHR calloc(MemoryStack stack) {
        return VkPerformanceCounterKHR.wrap(VkPerformanceCounterKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkPerformanceCounterKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkPerformanceCounterKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nunit(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNIT);
    }

    public static int nscope(long struct) {
        return UNSAFE.getInt(null, struct + (long)SCOPE);
    }

    public static int nstorage(long struct) {
        return UNSAFE.getInt(null, struct + (long)STORAGE);
    }

    public static ByteBuffer nuuid(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)UUID, 16);
    }

    public static byte nuuid(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)UUID + Checks.check(index, 16) * 1L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPerformanceCounterKHR.__struct(VkPerformanceCounterKHR.__member(4), VkPerformanceCounterKHR.__member(POINTER_SIZE), VkPerformanceCounterKHR.__member(4), VkPerformanceCounterKHR.__member(4), VkPerformanceCounterKHR.__member(4), VkPerformanceCounterKHR.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        UNIT = layout.offsetof(2);
        SCOPE = layout.offsetof(3);
        STORAGE = layout.offsetof(4);
        UUID = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPerformanceCounterKHR, Buffer>
    implements NativeResource {
        private static final VkPerformanceCounterKHR ELEMENT_FACTORY = VkPerformanceCounterKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPerformanceCounterKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPerformanceCounterKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPerformanceCounterKHR.npNext(this.address());
        }

        @NativeType(value="VkPerformanceCounterUnitKHR")
        public int unit() {
            return VkPerformanceCounterKHR.nunit(this.address());
        }

        @NativeType(value="VkPerformanceCounterScopeKHR")
        public int scope() {
            return VkPerformanceCounterKHR.nscope(this.address());
        }

        @NativeType(value="VkPerformanceCounterStorageKHR")
        public int storage() {
            return VkPerformanceCounterKHR.nstorage(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer uuid() {
            return VkPerformanceCounterKHR.nuuid(this.address());
        }

        @NativeType(value="uint8_t")
        public byte uuid(int index) {
            return VkPerformanceCounterKHR.nuuid(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPerformanceCounterKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000116005);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPerformanceCounterKHR.npNext(this.address(), value);
            return this;
        }
    }
}

