/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMutableDescriptorTypeListVALVE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DESCRIPTORTYPECOUNT;
    public static final int PDESCRIPTORTYPES;

    public VkMutableDescriptorTypeListVALVE(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMutableDescriptorTypeListVALVE.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int descriptorTypeCount() {
        return VkMutableDescriptorTypeListVALVE.ndescriptorTypeCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDescriptorType const *")
    public IntBuffer pDescriptorTypes() {
        return VkMutableDescriptorTypeListVALVE.npDescriptorTypes(this.address());
    }

    public VkMutableDescriptorTypeListVALVE pDescriptorTypes(@Nullable @NativeType(value="VkDescriptorType const *") IntBuffer value) {
        VkMutableDescriptorTypeListVALVE.npDescriptorTypes(this.address(), value);
        return this;
    }

    public VkMutableDescriptorTypeListVALVE set(VkMutableDescriptorTypeListVALVE src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMutableDescriptorTypeListVALVE malloc() {
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMutableDescriptorTypeListVALVE calloc() {
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMutableDescriptorTypeListVALVE create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMutableDescriptorTypeListVALVE create(long address) {
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, address);
    }

    @Nullable
    public static VkMutableDescriptorTypeListVALVE createSafe(long address) {
        return address == 0L ? null : VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMutableDescriptorTypeListVALVE.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMutableDescriptorTypeListVALVE.__create(capacity, SIZEOF);
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, address, capacity);
    }

    public static VkMutableDescriptorTypeListVALVE malloc(MemoryStack stack) {
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMutableDescriptorTypeListVALVE calloc(MemoryStack stack) {
        return VkMutableDescriptorTypeListVALVE.wrap(VkMutableDescriptorTypeListVALVE.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMutableDescriptorTypeListVALVE.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndescriptorTypeCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORTYPECOUNT);
    }

    @Nullable
    public static IntBuffer npDescriptorTypes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORTYPES), VkMutableDescriptorTypeListVALVE.ndescriptorTypeCount(struct));
    }

    public static void ndescriptorTypeCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORTYPECOUNT, value);
    }

    public static void npDescriptorTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDESCRIPTORTYPES, MemoryUtil.memAddressSafe(value));
        VkMutableDescriptorTypeListVALVE.ndescriptorTypeCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkMutableDescriptorTypeListVALVE.ndescriptorTypeCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORTYPES));
        }
    }

    static {
        Struct.Layout layout = VkMutableDescriptorTypeListVALVE.__struct(VkMutableDescriptorTypeListVALVE.__member(4), VkMutableDescriptorTypeListVALVE.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DESCRIPTORTYPECOUNT = layout.offsetof(0);
        PDESCRIPTORTYPES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkMutableDescriptorTypeListVALVE, Buffer>
    implements NativeResource {
        private static final VkMutableDescriptorTypeListVALVE ELEMENT_FACTORY = VkMutableDescriptorTypeListVALVE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMutableDescriptorTypeListVALVE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int descriptorTypeCount() {
            return VkMutableDescriptorTypeListVALVE.ndescriptorTypeCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDescriptorType const *")
        public IntBuffer pDescriptorTypes() {
            return VkMutableDescriptorTypeListVALVE.npDescriptorTypes(this.address());
        }

        public Buffer pDescriptorTypes(@Nullable @NativeType(value="VkDescriptorType const *") IntBuffer value) {
            VkMutableDescriptorTypeListVALVE.npDescriptorTypes(this.address(), value);
            return this;
        }
    }
}

