/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryBarrier2;

public class VkMemoryBarrier2KHR
extends VkMemoryBarrier2 {
    public VkMemoryBarrier2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryBarrier2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryBarrier2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR sType$Default() {
        return this.sType(1000314000);
    }

    @Override
    public VkMemoryBarrier2KHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryBarrier2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2KHR.nsrcStageMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2KHR.nsrcAccessMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2KHR.ndstStageMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2KHR.ndstAccessMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryBarrier2KHR set(int sType, long pNext, long srcStageMask, long srcAccessMask, long dstStageMask, long dstAccessMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcStageMask(srcStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstStageMask(dstStageMask);
        this.dstAccessMask(dstAccessMask);
        return this;
    }

    public VkMemoryBarrier2KHR set(VkMemoryBarrier2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryBarrier2KHR malloc() {
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkMemoryBarrier2KHR calloc() {
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkMemoryBarrier2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryBarrier2KHR create(long address) {
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, address);
    }

    @Nullable
    public static VkMemoryBarrier2KHR createSafe(long address) {
        return address == 0L ? null : VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkMemoryBarrier2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkMemoryBarrier2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkMemoryBarrier2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryBarrier2KHR.__create(capacity, SIZEOF);
        return VkMemoryBarrier2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkMemoryBarrier2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkMemoryBarrier2KHR.wrap(Buffer.class, address, capacity);
    }

    public static VkMemoryBarrier2KHR malloc(MemoryStack stack) {
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkMemoryBarrier2KHR calloc(MemoryStack stack) {
        return VkMemoryBarrier2KHR.wrap(VkMemoryBarrier2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkMemoryBarrier2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkMemoryBarrier2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryBarrier2.Buffer {
        private static final VkMemoryBarrier2KHR ELEMENT_FACTORY = VkMemoryBarrier2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryBarrier2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryBarrier2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000314000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryBarrier2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2KHR.nsrcStageMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2KHR.nsrcAccessMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2KHR.ndstStageMask(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2KHR.ndstAccessMask(this.address(), value);
            return this;
        }
    }
}

