/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresource
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int MIPLEVEL;
    public static final int ARRAYLAYER;

    public VkImageSubresource(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageSubresource.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkImageSubresource.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int mipLevel() {
        return VkImageSubresource.nmipLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int arrayLayer() {
        return VkImageSubresource.narrayLayer(this.address());
    }

    public VkImageSubresource aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkImageSubresource.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresource mipLevel(@NativeType(value="uint32_t") int value) {
        VkImageSubresource.nmipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresource arrayLayer(@NativeType(value="uint32_t") int value) {
        VkImageSubresource.narrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresource set(int aspectMask, int mipLevel, int arrayLayer) {
        this.aspectMask(aspectMask);
        this.mipLevel(mipLevel);
        this.arrayLayer(arrayLayer);
        return this;
    }

    public VkImageSubresource set(VkImageSubresource src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageSubresource malloc() {
        return VkImageSubresource.wrap(VkImageSubresource.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkImageSubresource calloc() {
        return VkImageSubresource.wrap(VkImageSubresource.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkImageSubresource create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkImageSubresource.wrap(VkImageSubresource.class, MemoryUtil.memAddress(container), container);
    }

    public static VkImageSubresource create(long address) {
        return VkImageSubresource.wrap(VkImageSubresource.class, address);
    }

    @Nullable
    public static VkImageSubresource createSafe(long address) {
        return address == 0L ? null : VkImageSubresource.wrap(VkImageSubresource.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkImageSubresource.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkImageSubresource.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkImageSubresource.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresource.__create(capacity, SIZEOF);
        return VkImageSubresource.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkImageSubresource.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkImageSubresource.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkImageSubresource mallocStack() {
        return VkImageSubresource.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresource callocStack() {
        return VkImageSubresource.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageSubresource mallocStack(MemoryStack stack) {
        return VkImageSubresource.malloc(stack);
    }

    @Deprecated
    public static VkImageSubresource callocStack(MemoryStack stack) {
        return VkImageSubresource.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageSubresource.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageSubresource.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageSubresource.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageSubresource.calloc(capacity, stack);
    }

    public static VkImageSubresource malloc(MemoryStack stack) {
        return VkImageSubresource.wrap(VkImageSubresource.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresource calloc(MemoryStack stack) {
        return VkImageSubresource.wrap(VkImageSubresource.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkImageSubresource.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkImageSubresource.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static int nmipLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIPLEVEL);
    }

    public static int narrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)ARRAYLAYER);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    public static void nmipLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIPLEVEL, value);
    }

    public static void narrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ARRAYLAYER, value);
    }

    static {
        Struct.Layout layout = VkImageSubresource.__struct(VkImageSubresource.__member(4), VkImageSubresource.__member(4), VkImageSubresource.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        MIPLEVEL = layout.offsetof(1);
        ARRAYLAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresource, Buffer>
    implements NativeResource {
        private static final VkImageSubresource ELEMENT_FACTORY = VkImageSubresource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImageSubresource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkImageSubresource.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int mipLevel() {
            return VkImageSubresource.nmipLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int arrayLayer() {
            return VkImageSubresource.narrayLayer(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkImageSubresource.naspectMask(this.address(), value);
            return this;
        }

        public Buffer mipLevel(@NativeType(value="uint32_t") int value) {
            VkImageSubresource.nmipLevel(this.address(), value);
            return this;
        }

        public Buffer arrayLayer(@NativeType(value="uint32_t") int value) {
            VkImageSubresource.narrayLayer(this.address(), value);
            return this;
        }
    }
}

