/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExternalMemoryBufferCreateInfo;

public class VkExternalMemoryBufferCreateInfoKHR
extends VkExternalMemoryBufferCreateInfo {
    public VkExternalMemoryBufferCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR sType$Default() {
        return this.sType(1000072000);
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExternalMemoryBufferCreateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryBufferCreateInfoKHR set(VkExternalMemoryBufferCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryBufferCreateInfoKHR malloc() {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR calloc() {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExternalMemoryBufferCreateInfoKHR create(long address) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, address);
    }

    @Nullable
    public static VkExternalMemoryBufferCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExternalMemoryBufferCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryBufferCreateInfoKHR.__create(capacity, SIZEOF);
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR mallocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR callocStack() {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryBufferCreateInfoKHR callocStack(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkExternalMemoryBufferCreateInfoKHR malloc(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalMemoryBufferCreateInfoKHR calloc(MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(VkExternalMemoryBufferCreateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExternalMemoryBufferCreateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExternalMemoryBufferCreateInfo.Buffer {
        private static final VkExternalMemoryBufferCreateInfoKHR ELEMENT_FACTORY = VkExternalMemoryBufferCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalMemoryBufferCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000072000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryBufferCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryBufferCreateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

