/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExternalMemoryProperties;

public class VkExternalBufferProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int EXTERNALMEMORYPROPERTIES;

    public VkExternalBufferProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalBufferProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalBufferProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkExternalBufferProperties.npNext(this.address());
    }

    public VkExternalMemoryProperties externalMemoryProperties() {
        return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
    }

    public VkExternalBufferProperties sType(@NativeType(value="VkStructureType") int value) {
        VkExternalBufferProperties.nsType(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties sType$Default() {
        return this.sType(1000071003);
    }

    public VkExternalBufferProperties pNext(@NativeType(value="void *") long value) {
        VkExternalBufferProperties.npNext(this.address(), value);
        return this;
    }

    public VkExternalBufferProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkExternalBufferProperties set(VkExternalBufferProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalBufferProperties malloc() {
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExternalBufferProperties calloc() {
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExternalBufferProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExternalBufferProperties create(long address) {
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, address);
    }

    @Nullable
    public static VkExternalBufferProperties createSafe(long address) {
        return address == 0L ? null : VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExternalBufferProperties.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExternalBufferProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExternalBufferProperties.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalBufferProperties.__create(capacity, SIZEOF);
        return VkExternalBufferProperties.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExternalBufferProperties.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExternalBufferProperties.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExternalBufferProperties mallocStack() {
        return VkExternalBufferProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalBufferProperties callocStack() {
        return VkExternalBufferProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalBufferProperties mallocStack(MemoryStack stack) {
        return VkExternalBufferProperties.malloc(stack);
    }

    @Deprecated
    public static VkExternalBufferProperties callocStack(MemoryStack stack) {
        return VkExternalBufferProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalBufferProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalBufferProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.calloc(capacity, stack);
    }

    public static VkExternalBufferProperties malloc(MemoryStack stack) {
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExternalBufferProperties calloc(MemoryStack stack) {
        return VkExternalBufferProperties.wrap(VkExternalBufferProperties.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExternalBufferProperties.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkExternalMemoryProperties nexternalMemoryProperties(long struct) {
        return VkExternalMemoryProperties.create(struct + (long)EXTERNALMEMORYPROPERTIES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkExternalBufferProperties.__struct(VkExternalBufferProperties.__member(4), VkExternalBufferProperties.__member(POINTER_SIZE), VkExternalBufferProperties.__member(VkExternalMemoryProperties.SIZEOF, VkExternalMemoryProperties.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        EXTERNALMEMORYPROPERTIES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalBufferProperties, Buffer>
    implements NativeResource {
        private static final VkExternalBufferProperties ELEMENT_FACTORY = VkExternalBufferProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExternalBufferProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalBufferProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkExternalBufferProperties.npNext(this.address());
        }

        public VkExternalMemoryProperties externalMemoryProperties() {
            return VkExternalBufferProperties.nexternalMemoryProperties(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalBufferProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000071003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkExternalBufferProperties.npNext(this.address(), value);
            return this;
        }
    }
}

