/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExportMemoryAllocateInfo;

public class VkExportMemoryAllocateInfoKHR
extends VkExportMemoryAllocateInfo {
    public VkExportMemoryAllocateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkExportMemoryAllocateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryAllocateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR sType$Default() {
        return this.sType(1000072002);
    }

    @Override
    public VkExportMemoryAllocateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryAllocateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExportMemoryAllocateInfoKHR.nhandleTypes(this.address(), value);
        return this;
    }

    @Override
    public VkExportMemoryAllocateInfoKHR set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportMemoryAllocateInfoKHR set(VkExportMemoryAllocateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryAllocateInfoKHR malloc() {
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR calloc() {
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExportMemoryAllocateInfoKHR create(long address) {
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, address);
    }

    @Nullable
    public static VkExportMemoryAllocateInfoKHR createSafe(long address) {
        return address == 0L ? null : VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExportMemoryAllocateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMemoryAllocateInfoKHR.__create(capacity, SIZEOF);
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoKHR mallocStack() {
        return VkExportMemoryAllocateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoKHR callocStack() {
        return VkExportMemoryAllocateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoKHR mallocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkExportMemoryAllocateInfoKHR callocStack(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportMemoryAllocateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.calloc(capacity, stack);
    }

    public static VkExportMemoryAllocateInfoKHR malloc(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportMemoryAllocateInfoKHR calloc(MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.wrap(VkExportMemoryAllocateInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExportMemoryAllocateInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkExportMemoryAllocateInfo.Buffer {
        private static final VkExportMemoryAllocateInfoKHR ELEMENT_FACTORY = VkExportMemoryAllocateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExportMemoryAllocateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryAllocateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000072002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryAllocateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExportMemoryAllocateInfoKHR.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

