/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExportFenceCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    public VkExportFenceCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExportFenceCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportFenceCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportFenceCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalFenceHandleTypeFlags")
    public int handleTypes() {
        return VkExportFenceCreateInfo.nhandleTypes(this.address());
    }

    public VkExportFenceCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExportFenceCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo sType$Default() {
        return this.sType(1000113000);
    }

    public VkExportFenceCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExportFenceCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
        VkExportFenceCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExportFenceCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExportFenceCreateInfo set(VkExportFenceCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportFenceCreateInfo malloc() {
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkExportFenceCreateInfo calloc() {
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkExportFenceCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VkExportFenceCreateInfo create(long address) {
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, address);
    }

    @Nullable
    public static VkExportFenceCreateInfo createSafe(long address) {
        return address == 0L ? null : VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkExportFenceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkExportFenceCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkExportFenceCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportFenceCreateInfo.__create(capacity, SIZEOF);
        return VkExportFenceCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkExportFenceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkExportFenceCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkExportFenceCreateInfo mallocStack() {
        return VkExportFenceCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportFenceCreateInfo callocStack() {
        return VkExportFenceCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportFenceCreateInfo mallocStack(MemoryStack stack) {
        return VkExportFenceCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkExportFenceCreateInfo callocStack(MemoryStack stack) {
        return VkExportFenceCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportFenceCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportFenceCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.calloc(capacity, stack);
    }

    public static VkExportFenceCreateInfo malloc(MemoryStack stack) {
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkExportFenceCreateInfo calloc(MemoryStack stack) {
        return VkExportFenceCreateInfo.wrap(VkExportFenceCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkExportFenceCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExportFenceCreateInfo.__struct(VkExportFenceCreateInfo.__member(4), VkExportFenceCreateInfo.__member(POINTER_SIZE), VkExportFenceCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExportFenceCreateInfo, Buffer>
    implements NativeResource {
        private static final VkExportFenceCreateInfo ELEMENT_FACTORY = VkExportFenceCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExportFenceCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportFenceCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportFenceCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalFenceHandleTypeFlags")
        public int handleTypes() {
            return VkExportFenceCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportFenceCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000113000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportFenceCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalFenceHandleTypeFlags") int value) {
            VkExportFenceCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

