/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDisplayPlanePropertiesKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURRENTDISPLAY;
    public static final int CURRENTSTACKINDEX;

    public VkDisplayPlanePropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayPlanePropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayKHR")
    public long currentDisplay() {
        return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
    }

    @NativeType(value="uint32_t")
    public int currentStackIndex() {
        return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
    }

    public static VkDisplayPlanePropertiesKHR malloc() {
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR calloc() {
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayPlanePropertiesKHR create(long address) {
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, address);
    }

    @Nullable
    public static VkDisplayPlanePropertiesKHR createSafe(long address) {
        return address == 0L ? null : VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDisplayPlanePropertiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayPlanePropertiesKHR.__create(capacity, SIZEOF);
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDisplayPlanePropertiesKHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR mallocStack() {
        return VkDisplayPlanePropertiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR callocStack() {
        return VkDisplayPlanePropertiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.calloc(capacity, stack);
    }

    public static VkDisplayPlanePropertiesKHR malloc(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR calloc(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.wrap(VkDisplayPlanePropertiesKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncurrentDisplay(long struct) {
        return UNSAFE.getLong(null, struct + (long)CURRENTDISPLAY);
    }

    public static int ncurrentStackIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENTSTACKINDEX);
    }

    static {
        Struct.Layout layout = VkDisplayPlanePropertiesKHR.__struct(VkDisplayPlanePropertiesKHR.__member(8), VkDisplayPlanePropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURRENTDISPLAY = layout.offsetof(0);
        CURRENTSTACKINDEX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPlanePropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayPlanePropertiesKHR ELEMENT_FACTORY = VkDisplayPlanePropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDisplayPlanePropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDisplayKHR")
        public long currentDisplay() {
            return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
        }

        @NativeType(value="uint32_t")
        public int currentStackIndex() {
            return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
        }
    }
}

