/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkDevicePrivateDataCreateInfo;

public class VkDevicePrivateDataCreateInfoEXT
extends VkDevicePrivateDataCreateInfo {
    public VkDevicePrivateDataCreateInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkDevicePrivateDataCreateInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDevicePrivateDataCreateInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkDevicePrivateDataCreateInfoEXT sType$Default() {
        return this.sType(1000295001);
    }

    @Override
    public VkDevicePrivateDataCreateInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDevicePrivateDataCreateInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkDevicePrivateDataCreateInfoEXT privateDataSlotRequestCount(@NativeType(value="uint32_t") int value) {
        VkDevicePrivateDataCreateInfoEXT.nprivateDataSlotRequestCount(this.address(), value);
        return this;
    }

    @Override
    public VkDevicePrivateDataCreateInfoEXT set(int sType, long pNext, int privateDataSlotRequestCount) {
        this.sType(sType);
        this.pNext(pNext);
        this.privateDataSlotRequestCount(privateDataSlotRequestCount);
        return this;
    }

    public VkDevicePrivateDataCreateInfoEXT set(VkDevicePrivateDataCreateInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDevicePrivateDataCreateInfoEXT malloc() {
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfoEXT calloc() {
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDevicePrivateDataCreateInfoEXT create(long address) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, address);
    }

    @Nullable
    public static VkDevicePrivateDataCreateInfoEXT createSafe(long address) {
        return address == 0L ? null : VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDevicePrivateDataCreateInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDevicePrivateDataCreateInfoEXT.__create(capacity, SIZEOF);
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, address, capacity);
    }

    public static VkDevicePrivateDataCreateInfoEXT malloc(MemoryStack stack) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDevicePrivateDataCreateInfoEXT calloc(MemoryStack stack) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(VkDevicePrivateDataCreateInfoEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDevicePrivateDataCreateInfoEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkDevicePrivateDataCreateInfo.Buffer {
        private static final VkDevicePrivateDataCreateInfoEXT ELEMENT_FACTORY = VkDevicePrivateDataCreateInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDevicePrivateDataCreateInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDevicePrivateDataCreateInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000295001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDevicePrivateDataCreateInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer privateDataSlotRequestCount(@NativeType(value="uint32_t") int value) {
            VkDevicePrivateDataCreateInfoEXT.nprivateDataSlotRequestCount(this.address(), value);
            return this;
        }
    }
}

