/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCreateInfo;

public class VkDeviceImageMemoryRequirements
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;
    public static final int PLANEASPECT;

    public VkDeviceImageMemoryRequirements(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceImageMemoryRequirements.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceImageMemoryRequirements.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceImageMemoryRequirements.npNext(this.address());
    }

    @NativeType(value="VkImageCreateInfo const *")
    public VkImageCreateInfo pCreateInfo() {
        return VkDeviceImageMemoryRequirements.npCreateInfo(this.address());
    }

    @NativeType(value="VkImageAspectFlagBits")
    public int planeAspect() {
        return VkDeviceImageMemoryRequirements.nplaneAspect(this.address());
    }

    public VkDeviceImageMemoryRequirements sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceImageMemoryRequirements.nsType(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements sType$Default() {
        return this.sType(1000413003);
    }

    public VkDeviceImageMemoryRequirements pNext(@NativeType(value="void const *") long value) {
        VkDeviceImageMemoryRequirements.npNext(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
        VkDeviceImageMemoryRequirements.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
        VkDeviceImageMemoryRequirements.nplaneAspect(this.address(), value);
        return this;
    }

    public VkDeviceImageMemoryRequirements set(int sType, long pNext, VkImageCreateInfo pCreateInfo, int planeAspect) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        this.planeAspect(planeAspect);
        return this;
    }

    public VkDeviceImageMemoryRequirements set(VkDeviceImageMemoryRequirements src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceImageMemoryRequirements malloc() {
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkDeviceImageMemoryRequirements calloc() {
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkDeviceImageMemoryRequirements create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceImageMemoryRequirements create(long address) {
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, address);
    }

    @Nullable
    public static VkDeviceImageMemoryRequirements createSafe(long address) {
        return address == 0L ? null : VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkDeviceImageMemoryRequirements.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceImageMemoryRequirements.__create(capacity, SIZEOF);
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkDeviceImageMemoryRequirements.wrap(Buffer.class, address, capacity);
    }

    public static VkDeviceImageMemoryRequirements malloc(MemoryStack stack) {
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDeviceImageMemoryRequirements calloc(MemoryStack stack) {
        return VkDeviceImageMemoryRequirements.wrap(VkDeviceImageMemoryRequirements.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkDeviceImageMemoryRequirements.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkImageCreateInfo npCreateInfo(long struct) {
        return VkImageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    public static int nplaneAspect(long struct) {
        return UNSAFE.getInt(null, struct + (long)PLANEASPECT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npCreateInfo(long struct, VkImageCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCREATEINFO, value.address());
    }

    public static void nplaneAspect(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PLANEASPECT, value);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    static {
        Struct.Layout layout = VkDeviceImageMemoryRequirements.__struct(VkDeviceImageMemoryRequirements.__member(4), VkDeviceImageMemoryRequirements.__member(POINTER_SIZE), VkDeviceImageMemoryRequirements.__member(POINTER_SIZE), VkDeviceImageMemoryRequirements.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
        PLANEASPECT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceImageMemoryRequirements, Buffer>
    implements NativeResource {
        private static final VkDeviceImageMemoryRequirements ELEMENT_FACTORY = VkDeviceImageMemoryRequirements.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceImageMemoryRequirements getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceImageMemoryRequirements.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceImageMemoryRequirements.npNext(this.address());
        }

        @NativeType(value="VkImageCreateInfo const *")
        public VkImageCreateInfo pCreateInfo() {
            return VkDeviceImageMemoryRequirements.npCreateInfo(this.address());
        }

        @NativeType(value="VkImageAspectFlagBits")
        public int planeAspect() {
            return VkDeviceImageMemoryRequirements.nplaneAspect(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceImageMemoryRequirements.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000413003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceImageMemoryRequirements.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
            VkDeviceImageMemoryRequirements.npCreateInfo(this.address(), value);
            return this;
        }

        public Buffer planeAspect(@NativeType(value="VkImageAspectFlagBits") int value) {
            VkDeviceImageMemoryRequirements.nplaneAspect(this.address(), value);
            return this;
        }
    }
}

