/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearColorValue;
import org.lwjgl.vulkan.VkClearDepthStencilValue;

public class VkClearValue
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COLOR;
    public static final int DEPTHSTENCIL;

    public VkClearValue(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkClearValue.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkClearColorValue color() {
        return VkClearValue.ncolor(this.address());
    }

    public VkClearDepthStencilValue depthStencil() {
        return VkClearValue.ndepthStencil(this.address());
    }

    public VkClearValue color(VkClearColorValue value) {
        VkClearValue.ncolor(this.address(), value);
        return this;
    }

    public VkClearValue color(Consumer<VkClearColorValue> consumer) {
        consumer.accept(this.color());
        return this;
    }

    public VkClearValue depthStencil(VkClearDepthStencilValue value) {
        VkClearValue.ndepthStencil(this.address(), value);
        return this;
    }

    public VkClearValue depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
        consumer.accept(this.depthStencil());
        return this;
    }

    public VkClearValue set(VkClearValue src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkClearValue malloc() {
        return VkClearValue.wrap(VkClearValue.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkClearValue calloc() {
        return VkClearValue.wrap(VkClearValue.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkClearValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkClearValue.wrap(VkClearValue.class, MemoryUtil.memAddress(container), container);
    }

    public static VkClearValue create(long address) {
        return VkClearValue.wrap(VkClearValue.class, address);
    }

    @Nullable
    public static VkClearValue createSafe(long address) {
        return address == 0L ? null : VkClearValue.wrap(VkClearValue.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkClearValue.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkClearValue.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkClearValue.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkClearValue.__create(capacity, SIZEOF);
        return VkClearValue.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkClearValue.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkClearValue.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkClearValue mallocStack() {
        return VkClearValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue callocStack() {
        return VkClearValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkClearValue mallocStack(MemoryStack stack) {
        return VkClearValue.malloc(stack);
    }

    @Deprecated
    public static VkClearValue callocStack(MemoryStack stack) {
        return VkClearValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkClearValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkClearValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkClearValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkClearValue.calloc(capacity, stack);
    }

    public static VkClearValue malloc(MemoryStack stack) {
        return VkClearValue.wrap(VkClearValue.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkClearValue calloc(MemoryStack stack) {
        return VkClearValue.wrap(VkClearValue.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkClearValue.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkClearValue.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkClearColorValue ncolor(long struct) {
        return VkClearColorValue.create(struct + (long)COLOR);
    }

    public static VkClearDepthStencilValue ndepthStencil(long struct) {
        return VkClearDepthStencilValue.create(struct + (long)DEPTHSTENCIL);
    }

    public static void ncolor(long struct, VkClearColorValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COLOR, VkClearColorValue.SIZEOF);
    }

    public static void ndepthStencil(long struct, VkClearDepthStencilValue value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DEPTHSTENCIL, VkClearDepthStencilValue.SIZEOF);
    }

    static {
        Struct.Layout layout = VkClearValue.__union(VkClearValue.__member(VkClearColorValue.SIZEOF, VkClearColorValue.ALIGNOF), VkClearValue.__member(VkClearDepthStencilValue.SIZEOF, VkClearDepthStencilValue.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COLOR = layout.offsetof(0);
        DEPTHSTENCIL = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkClearValue, Buffer>
    implements NativeResource {
        private static final VkClearValue ELEMENT_FACTORY = VkClearValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkClearValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkClearColorValue color() {
            return VkClearValue.ncolor(this.address());
        }

        public VkClearDepthStencilValue depthStencil() {
            return VkClearValue.ndepthStencil(this.address());
        }

        public Buffer color(VkClearColorValue value) {
            VkClearValue.ncolor(this.address(), value);
            return this;
        }

        public Buffer color(Consumer<VkClearColorValue> consumer) {
            consumer.accept(this.color());
            return this;
        }

        public Buffer depthStencil(VkClearDepthStencilValue value) {
            VkClearValue.ndepthStencil(this.address(), value);
            return this;
        }

        public Buffer depthStencil(Consumer<VkClearDepthStencilValue> consumer) {
            consumer.accept(this.depthStencil());
            return this;
        }
    }
}

