/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkBufferMemoryRequirementsInfo2;

public class VkBufferMemoryRequirementsInfo2KHR
extends VkBufferMemoryRequirementsInfo2 {
    public VkBufferMemoryRequirementsInfo2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkBufferMemoryRequirementsInfo2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR sType$Default() {
        return this.sType(1000146000);
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR pNext(@NativeType(value="void const *") long value) {
        VkBufferMemoryRequirementsInfo2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR buffer(@NativeType(value="VkBuffer") long value) {
        VkBufferMemoryRequirementsInfo2KHR.nbuffer(this.address(), value);
        return this;
    }

    @Override
    public VkBufferMemoryRequirementsInfo2KHR set(int sType, long pNext, long buffer) {
        this.sType(sType);
        this.pNext(pNext);
        this.buffer(buffer);
        return this;
    }

    public VkBufferMemoryRequirementsInfo2KHR set(VkBufferMemoryRequirementsInfo2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferMemoryRequirementsInfo2KHR malloc() {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR calloc() {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferMemoryRequirementsInfo2KHR create(long address) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, address);
    }

    @Nullable
    public static VkBufferMemoryRequirementsInfo2KHR createSafe(long address) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferMemoryRequirementsInfo2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferMemoryRequirementsInfo2KHR.__create(capacity, SIZEOF);
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2KHR mallocStack() {
        return VkBufferMemoryRequirementsInfo2KHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2KHR callocStack() {
        return VkBufferMemoryRequirementsInfo2KHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2KHR mallocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.malloc(stack);
    }

    @Deprecated
    public static VkBufferMemoryRequirementsInfo2KHR callocStack(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferMemoryRequirementsInfo2KHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.calloc(capacity, stack);
    }

    public static VkBufferMemoryRequirementsInfo2KHR malloc(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferMemoryRequirementsInfo2KHR calloc(MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(VkBufferMemoryRequirementsInfo2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferMemoryRequirementsInfo2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkBufferMemoryRequirementsInfo2.Buffer {
        private static final VkBufferMemoryRequirementsInfo2KHR ELEMENT_FACTORY = VkBufferMemoryRequirementsInfo2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferMemoryRequirementsInfo2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferMemoryRequirementsInfo2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000146000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferMemoryRequirementsInfo2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkBufferMemoryRequirementsInfo2KHR.nbuffer(this.address(), value);
            return this;
        }
    }
}

