/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkBufferImageCopy
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFEROFFSET;
    public static final int BUFFERROWLENGTH;
    public static final int BUFFERIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    public VkBufferImageCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferImageCopy.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bufferOffset() {
        return VkBufferImageCopy.nbufferOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferRowLength() {
        return VkBufferImageCopy.nbufferRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferImageHeight() {
        return VkBufferImageCopy.nbufferImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkBufferImageCopy.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkBufferImageCopy.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkBufferImageCopy.nimageExtent(this.address());
    }

    public VkBufferImageCopy bufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferImageCopy.nbufferOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy bufferRowLength(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy.nbufferRowLength(this.address(), value);
        return this;
    }

    public VkBufferImageCopy bufferImageHeight(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy.nbufferImageHeight(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageSubresource(VkImageSubresourceLayers value) {
        VkBufferImageCopy.nimageSubresource(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkBufferImageCopy imageOffset(VkOffset3D value) {
        VkBufferImageCopy.nimageOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkBufferImageCopy imageExtent(VkExtent3D value) {
        VkBufferImageCopy.nimageExtent(this.address(), value);
        return this;
    }

    public VkBufferImageCopy imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkBufferImageCopy set(long bufferOffset, int bufferRowLength, int bufferImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.bufferOffset(bufferOffset);
        this.bufferRowLength(bufferRowLength);
        this.bufferImageHeight(bufferImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkBufferImageCopy set(VkBufferImageCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferImageCopy malloc() {
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkBufferImageCopy calloc() {
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkBufferImageCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, MemoryUtil.memAddress(container), container);
    }

    public static VkBufferImageCopy create(long address) {
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, address);
    }

    @Nullable
    public static VkBufferImageCopy createSafe(long address) {
        return address == 0L ? null : VkBufferImageCopy.wrap(VkBufferImageCopy.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkBufferImageCopy.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkBufferImageCopy.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkBufferImageCopy.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferImageCopy.__create(capacity, SIZEOF);
        return VkBufferImageCopy.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkBufferImageCopy.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkBufferImageCopy.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkBufferImageCopy mallocStack() {
        return VkBufferImageCopy.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferImageCopy callocStack() {
        return VkBufferImageCopy.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkBufferImageCopy mallocStack(MemoryStack stack) {
        return VkBufferImageCopy.malloc(stack);
    }

    @Deprecated
    public static VkBufferImageCopy callocStack(MemoryStack stack) {
        return VkBufferImageCopy.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkBufferImageCopy.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkBufferImageCopy.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.calloc(capacity, stack);
    }

    public static VkBufferImageCopy malloc(MemoryStack stack) {
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkBufferImageCopy calloc(MemoryStack stack) {
        return VkBufferImageCopy.wrap(VkBufferImageCopy.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkBufferImageCopy.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbufferOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFEROFFSET);
    }

    public static int nbufferRowLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERROWLENGTH);
    }

    public static int nbufferImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nbufferOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFEROFFSET, value);
    }

    public static void nbufferRowLength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERROWLENGTH, value);
    }

    public static void nbufferImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkBufferImageCopy.__struct(VkBufferImageCopy.__member(8), VkBufferImageCopy.__member(4), VkBufferImageCopy.__member(4), VkBufferImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkBufferImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkBufferImageCopy.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFEROFFSET = layout.offsetof(0);
        BUFFERROWLENGTH = layout.offsetof(1);
        BUFFERIMAGEHEIGHT = layout.offsetof(2);
        IMAGESUBRESOURCE = layout.offsetof(3);
        IMAGEOFFSET = layout.offsetof(4);
        IMAGEEXTENT = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkBufferImageCopy, Buffer>
    implements NativeResource {
        private static final VkBufferImageCopy ELEMENT_FACTORY = VkBufferImageCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferImageCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long bufferOffset() {
            return VkBufferImageCopy.nbufferOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferRowLength() {
            return VkBufferImageCopy.nbufferRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferImageHeight() {
            return VkBufferImageCopy.nbufferImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkBufferImageCopy.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkBufferImageCopy.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkBufferImageCopy.nimageExtent(this.address());
        }

        public Buffer bufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferImageCopy.nbufferOffset(this.address(), value);
            return this;
        }

        public Buffer bufferRowLength(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy.nbufferRowLength(this.address(), value);
            return this;
        }

        public Buffer bufferImageHeight(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy.nbufferImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkBufferImageCopy.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkBufferImageCopy.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkBufferImageCopy.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

