/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkAttachmentSampleCountInfoAMD
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTSAMPLES;
    public static final int DEPTHSTENCILATTACHMENTSAMPLES;

    public VkAttachmentSampleCountInfoAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAttachmentSampleCountInfoAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAttachmentSampleCountInfoAMD.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAttachmentSampleCountInfoAMD.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkAttachmentSampleCountInfoAMD.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkSampleCountFlagBits const *")
    public IntBuffer pColorAttachmentSamples() {
        return VkAttachmentSampleCountInfoAMD.npColorAttachmentSamples(this.address());
    }

    @NativeType(value="VkSampleCountFlagBits")
    public int depthStencilAttachmentSamples() {
        return VkAttachmentSampleCountInfoAMD.ndepthStencilAttachmentSamples(this.address());
    }

    public VkAttachmentSampleCountInfoAMD sType(@NativeType(value="VkStructureType") int value) {
        VkAttachmentSampleCountInfoAMD.nsType(this.address(), value);
        return this;
    }

    public VkAttachmentSampleCountInfoAMD sType$Default() {
        return this.sType(1000044008);
    }

    public VkAttachmentSampleCountInfoAMD pNext(@NativeType(value="void const *") long value) {
        VkAttachmentSampleCountInfoAMD.npNext(this.address(), value);
        return this;
    }

    public VkAttachmentSampleCountInfoAMD pColorAttachmentSamples(@Nullable @NativeType(value="VkSampleCountFlagBits const *") IntBuffer value) {
        VkAttachmentSampleCountInfoAMD.npColorAttachmentSamples(this.address(), value);
        return this;
    }

    public VkAttachmentSampleCountInfoAMD depthStencilAttachmentSamples(@NativeType(value="VkSampleCountFlagBits") int value) {
        VkAttachmentSampleCountInfoAMD.ndepthStencilAttachmentSamples(this.address(), value);
        return this;
    }

    public VkAttachmentSampleCountInfoAMD set(int sType, long pNext, @Nullable IntBuffer pColorAttachmentSamples, int depthStencilAttachmentSamples) {
        this.sType(sType);
        this.pNext(pNext);
        this.pColorAttachmentSamples(pColorAttachmentSamples);
        this.depthStencilAttachmentSamples(depthStencilAttachmentSamples);
        return this;
    }

    public VkAttachmentSampleCountInfoAMD set(VkAttachmentSampleCountInfoAMD src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentSampleCountInfoAMD malloc() {
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAttachmentSampleCountInfoAMD calloc() {
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAttachmentSampleCountInfoAMD create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAttachmentSampleCountInfoAMD create(long address) {
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, address);
    }

    @Nullable
    public static VkAttachmentSampleCountInfoAMD createSafe(long address) {
        return address == 0L ? null : VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAttachmentSampleCountInfoAMD.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentSampleCountInfoAMD.__create(capacity, SIZEOF);
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, address, capacity);
    }

    public static VkAttachmentSampleCountInfoAMD malloc(MemoryStack stack) {
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentSampleCountInfoAMD calloc(MemoryStack stack) {
        return VkAttachmentSampleCountInfoAMD.wrap(VkAttachmentSampleCountInfoAMD.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAttachmentSampleCountInfoAMD.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static IntBuffer npColorAttachmentSamples(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTSAMPLES), VkAttachmentSampleCountInfoAMD.ncolorAttachmentCount(struct));
    }

    public static int ndepthStencilAttachmentSamples(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTHSTENCILATTACHMENTSAMPLES);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachmentSamples(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTSAMPLES, MemoryUtil.memAddressSafe(value));
        VkAttachmentSampleCountInfoAMD.ncolorAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndepthStencilAttachmentSamples(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEPTHSTENCILATTACHMENTSAMPLES, value);
    }

    public static void validate(long struct) {
        if (VkAttachmentSampleCountInfoAMD.ncolorAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTSAMPLES));
        }
    }

    static {
        Struct.Layout layout = VkAttachmentSampleCountInfoAMD.__struct(VkAttachmentSampleCountInfoAMD.__member(4), VkAttachmentSampleCountInfoAMD.__member(POINTER_SIZE), VkAttachmentSampleCountInfoAMD.__member(4), VkAttachmentSampleCountInfoAMD.__member(POINTER_SIZE), VkAttachmentSampleCountInfoAMD.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COLORATTACHMENTCOUNT = layout.offsetof(2);
        PCOLORATTACHMENTSAMPLES = layout.offsetof(3);
        DEPTHSTENCILATTACHMENTSAMPLES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkAttachmentSampleCountInfoAMD, Buffer>
    implements NativeResource {
        private static final VkAttachmentSampleCountInfoAMD ELEMENT_FACTORY = VkAttachmentSampleCountInfoAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAttachmentSampleCountInfoAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAttachmentSampleCountInfoAMD.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAttachmentSampleCountInfoAMD.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkAttachmentSampleCountInfoAMD.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkSampleCountFlagBits const *")
        public IntBuffer pColorAttachmentSamples() {
            return VkAttachmentSampleCountInfoAMD.npColorAttachmentSamples(this.address());
        }

        @NativeType(value="VkSampleCountFlagBits")
        public int depthStencilAttachmentSamples() {
            return VkAttachmentSampleCountInfoAMD.ndepthStencilAttachmentSamples(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAttachmentSampleCountInfoAMD.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000044008);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAttachmentSampleCountInfoAMD.npNext(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentSamples(@Nullable @NativeType(value="VkSampleCountFlagBits const *") IntBuffer value) {
            VkAttachmentSampleCountInfoAMD.npColorAttachmentSamples(this.address(), value);
            return this;
        }

        public Buffer depthStencilAttachmentSamples(@NativeType(value="VkSampleCountFlagBits") int value) {
            VkAttachmentSampleCountInfoAMD.ndepthStencilAttachmentSamples(this.address(), value);
            return this;
        }
    }
}

