/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAttachmentReference2;

public class VkAttachmentReference2KHR
extends VkAttachmentReference2 {
    public VkAttachmentReference2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkAttachmentReference2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkAttachmentReference2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkAttachmentReference2KHR sType$Default() {
        return this.sType(1000109001);
    }

    @Override
    public VkAttachmentReference2KHR pNext(@NativeType(value="void const *") long value) {
        VkAttachmentReference2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkAttachmentReference2KHR attachment(@NativeType(value="uint32_t") int value) {
        VkAttachmentReference2KHR.nattachment(this.address(), value);
        return this;
    }

    @Override
    public VkAttachmentReference2KHR layout(@NativeType(value="VkImageLayout") int value) {
        VkAttachmentReference2KHR.nlayout(this.address(), value);
        return this;
    }

    @Override
    public VkAttachmentReference2KHR aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkAttachmentReference2KHR.naspectMask(this.address(), value);
        return this;
    }

    @Override
    public VkAttachmentReference2KHR set(int sType, long pNext, int attachment, int layout, int aspectMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.attachment(attachment);
        this.layout(layout);
        this.aspectMask(aspectMask);
        return this;
    }

    public VkAttachmentReference2KHR set(VkAttachmentReference2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAttachmentReference2KHR malloc() {
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAttachmentReference2KHR calloc() {
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAttachmentReference2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAttachmentReference2KHR create(long address) {
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, address);
    }

    @Nullable
    public static VkAttachmentReference2KHR createSafe(long address) {
        return address == 0L ? null : VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAttachmentReference2KHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAttachmentReference2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAttachmentReference2KHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAttachmentReference2KHR.__create(capacity, SIZEOF);
        return VkAttachmentReference2KHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAttachmentReference2KHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAttachmentReference2KHR.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkAttachmentReference2KHR mallocStack() {
        return VkAttachmentReference2KHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference2KHR callocStack() {
        return VkAttachmentReference2KHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAttachmentReference2KHR mallocStack(MemoryStack stack) {
        return VkAttachmentReference2KHR.malloc(stack);
    }

    @Deprecated
    public static VkAttachmentReference2KHR callocStack(MemoryStack stack) {
        return VkAttachmentReference2KHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAttachmentReference2KHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAttachmentReference2KHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.calloc(capacity, stack);
    }

    public static VkAttachmentReference2KHR malloc(MemoryStack stack) {
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAttachmentReference2KHR calloc(MemoryStack stack) {
        return VkAttachmentReference2KHR.wrap(VkAttachmentReference2KHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAttachmentReference2KHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkAttachmentReference2.Buffer {
        private static final VkAttachmentReference2KHR ELEMENT_FACTORY = VkAttachmentReference2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAttachmentReference2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAttachmentReference2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000109001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAttachmentReference2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer attachment(@NativeType(value="uint32_t") int value) {
            VkAttachmentReference2KHR.nattachment(this.address(), value);
            return this;
        }

        @Override
        public Buffer layout(@NativeType(value="VkImageLayout") int value) {
            VkAttachmentReference2KHR.nlayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkAttachmentReference2KHR.naspectMask(this.address(), value);
            return this;
        }
    }
}

