/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationFunction;
import org.lwjgl.vulkan.VkAllocationFunctionI;
import org.lwjgl.vulkan.VkFreeFunction;
import org.lwjgl.vulkan.VkFreeFunctionI;
import org.lwjgl.vulkan.VkInternalAllocationNotification;
import org.lwjgl.vulkan.VkInternalAllocationNotificationI;
import org.lwjgl.vulkan.VkInternalFreeNotification;
import org.lwjgl.vulkan.VkInternalFreeNotificationI;
import org.lwjgl.vulkan.VkReallocationFunction;
import org.lwjgl.vulkan.VkReallocationFunctionI;

public class VkAllocationCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PUSERDATA;
    public static final int PFNALLOCATION;
    public static final int PFNREALLOCATION;
    public static final int PFNFREE;
    public static final int PFNINTERNALALLOCATION;
    public static final int PFNINTERNALFREE;

    public VkAllocationCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAllocationCallbacks.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VkAllocationCallbacks.npUserData(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkAllocationFunction")
    public VkAllocationFunction pfnAllocation() {
        return VkAllocationCallbacks.npfnAllocation(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkReallocationFunction")
    public VkReallocationFunction pfnReallocation() {
        return VkAllocationCallbacks.npfnReallocation(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkFreeFunction")
    public VkFreeFunction pfnFree() {
        return VkAllocationCallbacks.npfnFree(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalAllocationNotification")
    public VkInternalAllocationNotification pfnInternalAllocation() {
        return VkAllocationCallbacks.npfnInternalAllocation(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalFreeNotification")
    public VkInternalFreeNotification pfnInternalFree() {
        return VkAllocationCallbacks.npfnInternalFree(this.address());
    }

    public VkAllocationCallbacks pUserData(@NativeType(value="void *") long value) {
        VkAllocationCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnAllocation(@Nullable @NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
        VkAllocationCallbacks.npfnAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnReallocation(@Nullable @NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
        VkAllocationCallbacks.npfnReallocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnFree(@Nullable @NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
        VkAllocationCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
        VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
        VkAllocationCallbacks.npfnInternalFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks set(long pUserData, VkAllocationFunctionI pfnAllocation, VkReallocationFunctionI pfnReallocation, VkFreeFunctionI pfnFree, VkInternalAllocationNotificationI pfnInternalAllocation, VkInternalFreeNotificationI pfnInternalFree) {
        this.pUserData(pUserData);
        this.pfnAllocation(pfnAllocation);
        this.pfnReallocation(pfnReallocation);
        this.pfnFree(pfnFree);
        this.pfnInternalAllocation(pfnInternalAllocation);
        this.pfnInternalFree(pfnInternalFree);
        return this;
    }

    public VkAllocationCallbacks set(VkAllocationCallbacks src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAllocationCallbacks malloc() {
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAllocationCallbacks calloc() {
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAllocationCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAllocationCallbacks create(long address) {
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, address);
    }

    @Nullable
    public static VkAllocationCallbacks createSafe(long address) {
        return address == 0L ? null : VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAllocationCallbacks.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAllocationCallbacks.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAllocationCallbacks.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAllocationCallbacks.__create(capacity, SIZEOF);
        return VkAllocationCallbacks.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAllocationCallbacks.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAllocationCallbacks.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VkAllocationCallbacks mallocStack() {
        return VkAllocationCallbacks.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAllocationCallbacks callocStack() {
        return VkAllocationCallbacks.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkAllocationCallbacks mallocStack(MemoryStack stack) {
        return VkAllocationCallbacks.malloc(stack);
    }

    @Deprecated
    public static VkAllocationCallbacks callocStack(MemoryStack stack) {
        return VkAllocationCallbacks.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkAllocationCallbacks.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkAllocationCallbacks.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.calloc(capacity, stack);
    }

    public static VkAllocationCallbacks malloc(MemoryStack stack) {
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAllocationCallbacks calloc(MemoryStack stack) {
        return VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAllocationCallbacks.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    @Nullable
    public static VkAllocationFunction npfnAllocation(long struct) {
        return VkAllocationFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNALLOCATION));
    }

    @Nullable
    public static VkReallocationFunction npfnReallocation(long struct) {
        return VkReallocationFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNREALLOCATION));
    }

    @Nullable
    public static VkFreeFunction npfnFree(long struct) {
        return VkFreeFunction.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNFREE));
    }

    @Nullable
    public static VkInternalAllocationNotification npfnInternalAllocation(long struct) {
        return VkInternalAllocationNotification.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNINTERNALALLOCATION));
    }

    @Nullable
    public static VkInternalFreeNotification npfnInternalFree(long struct) {
        return VkInternalFreeNotification.createSafe(MemoryUtil.memGetAddress(struct + (long)PFNINTERNALFREE));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    public static void npfnAllocation(long struct, @Nullable VkAllocationFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNALLOCATION, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnReallocation(long struct, @Nullable VkReallocationFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNREALLOCATION, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnFree(long struct, @Nullable VkFreeFunctionI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNFREE, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnInternalAllocation(long struct, @Nullable VkInternalAllocationNotificationI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALALLOCATION, MemoryUtil.memAddressSafe(value));
    }

    public static void npfnInternalFree(long struct, @Nullable VkInternalFreeNotificationI value) {
        MemoryUtil.memPutAddress(struct + (long)PFNINTERNALFREE, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkAllocationCallbacks.__struct(VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE), VkAllocationCallbacks.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PUSERDATA = layout.offsetof(0);
        PFNALLOCATION = layout.offsetof(1);
        PFNREALLOCATION = layout.offsetof(2);
        PFNFREE = layout.offsetof(3);
        PFNINTERNALALLOCATION = layout.offsetof(4);
        PFNINTERNALFREE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkAllocationCallbacks, Buffer>
    implements NativeResource {
        private static final VkAllocationCallbacks ELEMENT_FACTORY = VkAllocationCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAllocationCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VkAllocationCallbacks.npUserData(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkAllocationFunction")
        public VkAllocationFunction pfnAllocation() {
            return VkAllocationCallbacks.npfnAllocation(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkReallocationFunction")
        public VkReallocationFunction pfnReallocation() {
            return VkAllocationCallbacks.npfnReallocation(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkFreeFunction")
        public VkFreeFunction pfnFree() {
            return VkAllocationCallbacks.npfnFree(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalAllocationNotification")
        public VkInternalAllocationNotification pfnInternalAllocation() {
            return VkAllocationCallbacks.npfnInternalAllocation(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalFreeNotification")
        public VkInternalFreeNotification pfnInternalFree() {
            return VkAllocationCallbacks.npfnInternalFree(this.address());
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VkAllocationCallbacks.npUserData(this.address(), value);
            return this;
        }

        public Buffer pfnAllocation(@Nullable @NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
            VkAllocationCallbacks.npfnAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnReallocation(@Nullable @NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
            VkAllocationCallbacks.npfnReallocation(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@Nullable @NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
            VkAllocationCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
            VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
            VkAllocationCallbacks.npfnInternalFree(this.address(), value);
            return this;
        }
    }
}

