/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAccelerationStructureGeometryKHR;
import org.lwjgl.vulkan.VkDeviceOrHostAddressKHR;

public class VkAccelerationStructureBuildGeometryInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TYPE;
    public static final int FLAGS;
    public static final int MODE;
    public static final int SRCACCELERATIONSTRUCTURE;
    public static final int DSTACCELERATIONSTRUCTURE;
    public static final int GEOMETRYCOUNT;
    public static final int PGEOMETRIES;
    public static final int PPGEOMETRIES;
    public static final int SCRATCHDATA;

    public VkAccelerationStructureBuildGeometryInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkAccelerationStructureBuildGeometryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkAccelerationStructureTypeKHR")
    public int type() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureFlagsKHR")
    public int flags() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkBuildAccelerationStructureModeKHR")
    public int mode() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long srcAccelerationStructure() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR")
    public long dstAccelerationStructure() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address());
    }

    @NativeType(value="uint32_t")
    public int geometryCount() {
        return VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address());
    }

    @Nullable
    @NativeType(value="VkAccelerationStructureGeometryKHR const *")
    public VkAccelerationStructureGeometryKHR.Buffer pGeometries() {
        return VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address());
    }

    @Nullable
    @NativeType(value="VkAccelerationStructureGeometryKHR const * const *")
    public PointerBuffer ppGeometries() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address());
    }

    public VkDeviceOrHostAddressKHR scratchData() {
        return VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address());
    }

    public VkAccelerationStructureBuildGeometryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR sType$Default() {
        return this.sType(1000150000);
    }

    public VkAccelerationStructureBuildGeometryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR flags(@NativeType(value="VkBuildAccelerationStructureFlagsKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR mode(@NativeType(value="VkBuildAccelerationStructureModeKHR") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR srcAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR dstAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR geometryCount(@NativeType(value="uint32_t") int value) {
        VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR pGeometries(@Nullable @NativeType(value="VkAccelerationStructureGeometryKHR const *") VkAccelerationStructureGeometryKHR.Buffer value) {
        VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR ppGeometries(@Nullable @NativeType(value="VkAccelerationStructureGeometryKHR const * const *") PointerBuffer value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR scratchData(VkDeviceOrHostAddressKHR value) {
        VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address(), value);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
        consumer.accept(this.scratchData());
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR set(int sType, long pNext, int type, int flags, int mode, long srcAccelerationStructure, long dstAccelerationStructure, int geometryCount, @Nullable VkAccelerationStructureGeometryKHR.Buffer pGeometries, @Nullable PointerBuffer ppGeometries, VkDeviceOrHostAddressKHR scratchData) {
        this.sType(sType);
        this.pNext(pNext);
        this.type(type);
        this.flags(flags);
        this.mode(mode);
        this.srcAccelerationStructure(srcAccelerationStructure);
        this.dstAccelerationStructure(dstAccelerationStructure);
        this.geometryCount(geometryCount);
        this.pGeometries(pGeometries);
        this.ppGeometries(ppGeometries);
        this.scratchData(scratchData);
        return this;
    }

    public VkAccelerationStructureBuildGeometryInfoKHR set(VkAccelerationStructureBuildGeometryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR malloc() {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR calloc() {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR create(long address) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, address);
    }

    @Nullable
    public static VkAccelerationStructureBuildGeometryInfoKHR createSafe(long address) {
        return address == 0L ? null : VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VkAccelerationStructureBuildGeometryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAccelerationStructureBuildGeometryInfoKHR.__create(capacity, SIZEOF);
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, address, capacity);
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR malloc(MemoryStack stack) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAccelerationStructureBuildGeometryInfoKHR calloc(MemoryStack stack) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(VkAccelerationStructureBuildGeometryInfoKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VkAccelerationStructureBuildGeometryInfoKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nmode(long struct) {
        return UNSAFE.getInt(null, struct + (long)MODE);
    }

    public static long nsrcAccelerationStructure(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCACCELERATIONSTRUCTURE);
    }

    public static long ndstAccelerationStructure(long struct) {
        return UNSAFE.getLong(null, struct + (long)DSTACCELERATIONSTRUCTURE);
    }

    public static int ngeometryCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)GEOMETRYCOUNT);
    }

    @Nullable
    public static VkAccelerationStructureGeometryKHR.Buffer npGeometries(long struct) {
        return VkAccelerationStructureGeometryKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PGEOMETRIES), VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(struct));
    }

    @Nullable
    public static PointerBuffer nppGeometries(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPGEOMETRIES), VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(struct));
    }

    public static VkDeviceOrHostAddressKHR nscratchData(long struct) {
        return VkDeviceOrHostAddressKHR.create(struct + (long)SCRATCHDATA);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nmode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MODE, value);
    }

    public static void nsrcAccelerationStructure(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCACCELERATIONSTRUCTURE, value);
    }

    public static void ndstAccelerationStructure(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)DSTACCELERATIONSTRUCTURE, value);
    }

    public static void ngeometryCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)GEOMETRYCOUNT, value);
    }

    public static void npGeometries(long struct, @Nullable VkAccelerationStructureGeometryKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PGEOMETRIES, MemoryUtil.memAddressSafe(value));
    }

    public static void nppGeometries(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPGEOMETRIES, MemoryUtil.memAddressSafe(value));
    }

    public static void nscratchData(long struct, VkDeviceOrHostAddressKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SCRATCHDATA, VkDeviceOrHostAddressKHR.SIZEOF);
    }

    static {
        Struct.Layout layout = VkAccelerationStructureBuildGeometryInfoKHR.__struct(VkAccelerationStructureBuildGeometryInfoKHR.__member(4), VkAccelerationStructureBuildGeometryInfoKHR.__member(POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member(4), VkAccelerationStructureBuildGeometryInfoKHR.__member(4), VkAccelerationStructureBuildGeometryInfoKHR.__member(4), VkAccelerationStructureBuildGeometryInfoKHR.__member(8), VkAccelerationStructureBuildGeometryInfoKHR.__member(8), VkAccelerationStructureBuildGeometryInfoKHR.__member(4), VkAccelerationStructureBuildGeometryInfoKHR.__member(POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member(POINTER_SIZE), VkAccelerationStructureBuildGeometryInfoKHR.__member(VkDeviceOrHostAddressKHR.SIZEOF, VkDeviceOrHostAddressKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TYPE = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        MODE = layout.offsetof(4);
        SRCACCELERATIONSTRUCTURE = layout.offsetof(5);
        DSTACCELERATIONSTRUCTURE = layout.offsetof(6);
        GEOMETRYCOUNT = layout.offsetof(7);
        PGEOMETRIES = layout.offsetof(8);
        PPGEOMETRIES = layout.offsetof(9);
        SCRATCHDATA = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkAccelerationStructureBuildGeometryInfoKHR, Buffer>
    implements NativeResource {
        private static final VkAccelerationStructureBuildGeometryInfoKHR ELEMENT_FACTORY = VkAccelerationStructureBuildGeometryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkAccelerationStructureBuildGeometryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkAccelerationStructureTypeKHR")
        public int type() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureFlagsKHR")
        public int flags() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkBuildAccelerationStructureModeKHR")
        public int mode() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long srcAccelerationStructure() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR")
        public long dstAccelerationStructure() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address());
        }

        @NativeType(value="uint32_t")
        public int geometryCount() {
            return VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address());
        }

        @Nullable
        @NativeType(value="VkAccelerationStructureGeometryKHR const *")
        public VkAccelerationStructureGeometryKHR.Buffer pGeometries() {
            return VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address());
        }

        @Nullable
        @NativeType(value="VkAccelerationStructureGeometryKHR const * const *")
        public PointerBuffer ppGeometries() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address());
        }

        public VkDeviceOrHostAddressKHR scratchData() {
            return VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer type(@NativeType(value="VkAccelerationStructureTypeKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkBuildAccelerationStructureFlagsKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer mode(@NativeType(value="VkBuildAccelerationStructureModeKHR") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nmode(this.address(), value);
            return this;
        }

        public Buffer srcAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nsrcAccelerationStructure(this.address(), value);
            return this;
        }

        public Buffer dstAccelerationStructure(@NativeType(value="VkAccelerationStructureKHR") long value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ndstAccelerationStructure(this.address(), value);
            return this;
        }

        public Buffer geometryCount(@NativeType(value="uint32_t") int value) {
            VkAccelerationStructureBuildGeometryInfoKHR.ngeometryCount(this.address(), value);
            return this;
        }

        public Buffer pGeometries(@Nullable @NativeType(value="VkAccelerationStructureGeometryKHR const *") VkAccelerationStructureGeometryKHR.Buffer value) {
            VkAccelerationStructureBuildGeometryInfoKHR.npGeometries(this.address(), value);
            return this;
        }

        public Buffer ppGeometries(@Nullable @NativeType(value="VkAccelerationStructureGeometryKHR const * const *") PointerBuffer value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nppGeometries(this.address(), value);
            return this;
        }

        public Buffer scratchData(VkDeviceOrHostAddressKHR value) {
            VkAccelerationStructureBuildGeometryInfoKHR.nscratchData(this.address(), value);
            return this;
        }

        public Buffer scratchData(Consumer<VkDeviceOrHostAddressKHR> consumer) {
            consumer.accept(this.scratchData());
            return this;
        }
    }
}

