/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_DrawingSurface")
public class JAWTDrawingSurface
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ENV;
    public static final int TARGET;
    public static final int LOCK;
    public static final int GETDRAWINGSURFACEINFO;
    public static final int FREEDRAWINGSURFACEINFO;
    public static final int UNLOCK;

    public JAWTDrawingSurface(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), JAWTDrawingSurface.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="JNIEnv *")
    public long env() {
        return JAWTDrawingSurface.nenv(this.address());
    }

    @NativeType(value="jobject")
    public long target() {
        return JAWTDrawingSurface.ntarget(this.address());
    }

    @NativeType(value="void *")
    public long Lock() {
        return JAWTDrawingSurface.nLock(this.address());
    }

    @NativeType(value="void *")
    public long GetDrawingSurfaceInfo() {
        return JAWTDrawingSurface.nGetDrawingSurfaceInfo(this.address());
    }

    @NativeType(value="void *")
    public long FreeDrawingSurfaceInfo() {
        return JAWTDrawingSurface.nFreeDrawingSurfaceInfo(this.address());
    }

    @NativeType(value="void *")
    public long Unlock() {
        return JAWTDrawingSurface.nUnlock(this.address());
    }

    public static JAWTDrawingSurface create(long address) {
        return JAWTDrawingSurface.wrap(JAWTDrawingSurface.class, address);
    }

    @Nullable
    public static JAWTDrawingSurface createSafe(long address) {
        return address == 0L ? null : JAWTDrawingSurface.wrap(JAWTDrawingSurface.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return JAWTDrawingSurface.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : JAWTDrawingSurface.wrap(Buffer.class, address, capacity);
    }

    public static long nenv(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ENV);
    }

    public static long ntarget(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TARGET);
    }

    public static long nLock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)LOCK);
    }

    public static long nGetDrawingSurfaceInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GETDRAWINGSURFACEINFO);
    }

    public static long nFreeDrawingSurfaceInfo(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)FREEDRAWINGSURFACEINFO);
    }

    public static long nUnlock(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)UNLOCK);
    }

    static {
        Struct.Layout layout = JAWTDrawingSurface.__struct(JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE), JAWTDrawingSurface.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ENV = layout.offsetof(0);
        TARGET = layout.offsetof(1);
        LOCK = layout.offsetof(2);
        GETDRAWINGSURFACEINFO = layout.offsetof(3);
        FREEDRAWINGSURFACEINFO = layout.offsetof(4);
        UNLOCK = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<JAWTDrawingSurface, Buffer> {
        private static final JAWTDrawingSurface ELEMENT_FACTORY = JAWTDrawingSurface.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected JAWTDrawingSurface getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="JNIEnv *")
        public long env() {
            return JAWTDrawingSurface.nenv(this.address());
        }

        @NativeType(value="jobject")
        public long target() {
            return JAWTDrawingSurface.ntarget(this.address());
        }

        @NativeType(value="void *")
        public long Lock() {
            return JAWTDrawingSurface.nLock(this.address());
        }

        @NativeType(value="void *")
        public long GetDrawingSurfaceInfo() {
            return JAWTDrawingSurface.nGetDrawingSurfaceInfo(this.address());
        }

        @NativeType(value="void *")
        public long FreeDrawingSurfaceInfo() {
            return JAWTDrawingSurface.nFreeDrawingSurfaceInfo(this.address());
        }

        @NativeType(value="void *")
        public long Unlock() {
            return JAWTDrawingSurface.nUnlock(this.address());
        }
    }
}

